/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.webapp;

import fiftyone.mobile.detection.webapp.Stat;
import java.util.ArrayList;
import java.util.List;

public class Stats
extends ArrayList<Stat> {
    private static final long FIVE_MINUTES = 300000L;
    long lastId = 0L;

    public long getLastResponseTime() {
        Stat stat = this.getLastComplete();
        return stat == null ? -1L : stat.getResponseTime();
    }

    void removeOld() {
        long l = System.currentTimeMillis();
        ArrayList<Stat> arrayList = new ArrayList<Stat>();
        for (Stat stat : this) {
            if (l - stat.serverTimeRecieved <= 300000L) continue;
            arrayList.add(stat);
        }
        this.removeAll(arrayList);
    }

    public long getLastCompletionTime() {
        Stat stat = this.getLastComplete();
        return stat == null ? -1L : stat.getCompletionTime();
    }

    public long getAverageResponseTime() {
        List<Stat> list = this.getAllComplete();
        if (list.size() > 0) {
            long l = 0L;
            for (Stat stat : list) {
                l += stat.getResponseTime();
            }
            return l / (long)list.size();
        }
        return 0L;
    }

    public long getAverageCompletionTime() {
        List<Stat> list = this.getAllComplete();
        if (list.size() > 0) {
            long l = 0L;
            for (Stat stat : list) {
                l += stat.getCompletionTime();
            }
            return l / (long)list.size();
        }
        return 0L;
    }

    public int getAverageBandwidth() {
        List<Stat> list = this.getAllComplete();
        if (list.size() > 0) {
            int n = 0;
            for (Stat stat : list) {
                n = (int)((double)n + stat.getBandwidth());
            }
            return n / list.size();
        }
        return 0;
    }

    private List<Stat> getAllComplete() {
        ArrayList<Stat> arrayList = new ArrayList<Stat>();
        for (Stat stat : this) {
            if (!stat.isComplete()) continue;
            arrayList.add(stat);
        }
        return arrayList;
    }

    private Stat getLastComplete() {
        for (int i = this.size() - 1; i >= 0; --i) {
            Stat stat = (Stat)this.get(i);
            if (!stat.isComplete()) continue;
            return stat;
        }
        return null;
    }

    public Stat fetch(long l) {
        for (Stat stat : this) {
            if (l != stat.id) continue;
            return stat;
        }
        return null;
    }
}

