/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.webapp;

import java.io.Serializable;

public class Stat
implements Comparable<Stat>,
Serializable {
    long serverTimeSent;
    long browserTimeRecieved;
    long browserTimeCompleted;
    long browserTimeSent;
    long serverTimeRecieved;
    int responseLength;
    int requestLength;
    final long id = System.currentTimeMillis();

    public long getServerProcessingTime() {
        if (this.serverTimeSent >= this.serverTimeRecieved) {
            return this.serverTimeSent - this.serverTimeRecieved;
        }
        return -1L;
    }

    public long getResponseTime() {
        if (this.browserTimeRecieved >= this.browserTimeSent) {
            return this.browserTimeRecieved - this.browserTimeSent;
        }
        return -1L;
    }

    public long getCompletionTime() {
        if (this.browserTimeCompleted >= this.browserTimeSent) {
            return this.browserTimeCompleted - this.browserTimeSent;
        }
        return -1L;
    }

    public double getBandwidth() {
        if (this.getResponseTime() != -1L && this.getServerProcessingTime() != -1L) {
            return (double)(this.requestLength + this.responseLength) / (double)(this.getResponseTime() - this.getServerProcessingTime()) / 1000.0;
        }
        return 0.0;
    }

    public boolean isComplete() {
        return this.browserTimeSent > 0L && this.browserTimeRecieved >= this.browserTimeSent && this.browserTimeCompleted >= this.browserTimeSent && this.serverTimeRecieved > 0L && this.serverTimeSent >= this.serverTimeRecieved;
    }

    @Override
    public int compareTo(Stat stat) {
        return this.id - stat.id > 0L ? 1 : -1;
    }
}

