/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.webapp;

import fiftyone.mobile.detection.webapp.Constants;
import fiftyone.mobile.detection.webapp.NewDeviceDetails;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ShareUsage
implements Runnable {
    private final Object wait = new Object();
    private static String _productName = "51Degrees.mobi - Detection - Java";
    private boolean stop = false;
    private final String newDevicesUrl;
    private final NewDeviceDetails newDeviceDetail;
    private final LinkedBlockingQueue<byte[]> queue;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final String[] local = new String[]{"127.0.0.1", "0:0:0:0:0:0:0:1"};
    final Logger logger = LoggerFactory.getLogger(ShareUsage.class);

    public ShareUsage(String string, NewDeviceDetails newDeviceDetails) {
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.newDevicesUrl = string;
        this.newDeviceDetail = newDeviceDetails;
        this.queue = new LinkedBlockingQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.logger.trace("Destroying 51Degrees.mobi ShareUsage");
        this.stop = true;
        Object object = this.wait;
        synchronized (object) {
            this.wait.notifyAll();
        }
        this.logger.trace("Destroyed 51Degrees.mobi ShareUsage");
    }

    public void recordNewDevice(HttpServletRequest httpServletRequest) throws XMLStreamException, IOException {
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            hashMap.put(string, httpServletRequest.getHeader(string));
        }
        this.recordNewDevice(hashMap, httpServletRequest.getRemoteAddr(), httpServletRequest.getRequestURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordNewDevice(HashMap<String, String> hashMap, String string, String string2) throws XMLStreamException, IOException {
        byte[] byArray = ShareUsage.getContent(hashMap, string, string2, this.newDeviceDetail);
        if (byArray != null && byArray.length > 0) {
            this.queue.add(byArray);
            Object object = this.wait;
            synchronized (object) {
                this.wait.notify();
            }
        }
    }

    private void sendData(OutputStream outputStream) throws IOException, XMLStreamException {
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(outputStream);
        PrintWriter printWriter = new PrintWriter(gZIPOutputStream);
        printWriter.print("<?xml version=\"1.0\" ?>");
        printWriter.print("<Devices>");
        while (this.queue.size() > 0) {
            byte[] byArray = this.queue.poll();
            if (byArray == null || byArray.length <= 0) continue;
            printWriter.print(new String(byArray));
        }
        printWriter.print("</Devices>");
        printWriter.close();
        gZIPOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        do {
            try {
                Object object = this.wait;
                synchronized (object) {
                    this.wait.wait();
                }
                int n = this.queue.size();
                if (n < 50 && (!this.stop || this.queue.size() <= 0)) continue;
                HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(this.newDevicesUrl).openConnection();
                httpURLConnection.setReadTimeout(10000);
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setUseCaches(false);
                httpURLConnection.setRequestProperty("Content-Type", "text/xml; charset=ISO-8859-1");
                httpURLConnection.setRequestProperty("Content-Encoding", "gzip");
                httpURLConnection.setDoInput(true);
                httpURLConnection.setDoOutput(true);
                try {
                    this.sendData(httpURLConnection.getOutputStream());
                }
                catch (UnknownHostException unknownHostException) {
                    this.stop = true;
                }
                InputStreamReader inputStreamReader = new InputStreamReader(httpURLConnection.getInputStream());
                if (!inputStreamReader.ready()) continue;
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                if (bufferedReader != null) {
                    switch (httpURLConnection.getResponseCode()) {
                        case 200: {
                            break;
                        }
                        case 408: {
                            break;
                        }
                        default: {
                            this.stop = true;
                        }
                    }
                }
                bufferedReader.close();
            }
            catch (SecurityException securityException) {
                this.stop = true;
            }
            catch (XMLStreamException xMLStreamException) {
                this.stop = true;
            }
            catch (IOException iOException) {
                this.stop = true;
            }
            catch (InterruptedException interruptedException) {
                this.stop = true;
            }
            catch (IllegalStateException illegalStateException) {
                this.stop = true;
            }
        } while (!this.stop);
    }

    private static boolean isLocal(String string) {
        for (String string2 : local) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private static byte[] getContent(HashMap<String, String> hashMap, String string, String string2, NewDeviceDetails newDeviceDetails) throws XMLStreamException, IOException {
        boolean bl;
        boolean bl2 = bl = hashMap.get("51D") != null || string2.endsWith("asmx");
        if (!bl) {
            XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XMLStreamWriter xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter(byteArrayOutputStream);
            xMLStreamWriter.writeStartElement("Device");
            xMLStreamWriter.writeStartElement("DateSent");
            xMLStreamWriter.writeCharacters(dateFormat.format(new Date()).toString());
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeStartElement("Version");
            xMLStreamWriter.writeCharacters("3.1.6.1");
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeStartElement("Product");
            xMLStreamWriter.writeCharacters(_productName);
            xMLStreamWriter.writeEndElement();
            if (!ShareUsage.isLocal(string)) {
                xMLStreamWriter.writeStartElement("ClientIP");
                xMLStreamWriter.writeCharacters(string);
                xMLStreamWriter.writeEndElement();
            }
            xMLStreamWriter.writeStartElement("ServerIP");
            xMLStreamWriter.writeCharacters(string);
            xMLStreamWriter.writeEndElement();
            for (String string3 : hashMap.keySet()) {
                boolean bl3 = false;
                for (String string4 : Constants.IGNORE_HEADER_FIELD_VALUES) {
                    bl3 = string3.toLowerCase().contains(string4.toLowerCase());
                    if (bl3) break;
                }
                if (newDeviceDetails != NewDeviceDetails.MAXIMUM && !string3.equals("user-agent") && !string3.equals("host") && !string3.contains("profile") && !bl3) continue;
                if (bl3) {
                    xMLStreamWriter.writeStartElement("Header");
                    xMLStreamWriter.writeAttribute("Name", string3);
                    xMLStreamWriter.writeEndElement();
                    continue;
                }
                xMLStreamWriter.writeStartElement("Header");
                xMLStreamWriter.writeAttribute("Name", string3);
                xMLStreamWriter.writeCData(hashMap.get(string3));
                xMLStreamWriter.writeEndElement();
            }
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.close();
            return byteArrayOutputStream.toByteArray();
        }
        return null;
    }
}

