/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.webapp;

import fiftyone.mobile.detection.webapp.AutoUpdate;
import fiftyone.mobile.detection.webapp.FileUpdate;
import fiftyone.mobile.detection.webapp.WebProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FiftyOneDegreesListener
implements ServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(FiftyOneDegreesListener.class);
    private Timer autoUpdateTimer;
    private Timer fileUpdateTimer;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        logger.debug("Starting 51Degrees Listener Initialisation");
        File file = WebProvider.getBinaryFilePath(servletContextEvent.getServletContext());
        if (file != null) {
            List<String> list = this.getLicenceKeys(servletContextEvent.getServletContext());
            if (list.size() > 0) {
                this.autoUpdateTimer = new Timer();
                this.autoUpdateTimer.schedule((TimerTask)new AutoUpdate(file.getAbsolutePath(), list), 10000L, 1800000L);
            }
            this.fileUpdateTimer = new Timer();
            this.fileUpdateTimer.schedule((TimerTask)new FileUpdate(this, file.getAbsolutePath()), 300000L, 120000L);
        }
        logger.debug("Finished 51Degrees Listener Initialisation");
    }

    private List<String> getLicenceKeys(ServletContext servletContext) {
        File file = new File(servletContext.getRealPath("WEB-INF"));
        ArrayList<String> arrayList = new ArrayList<String>();
        for (File file2 : file.listFiles()) {
            if (!file2.getName().toLowerCase().endsWith("lic")) continue;
            try {
                Scanner scanner = new Scanner(new FileReader(file2));
                while (scanner.hasNextLine()) {
                    arrayList.add(scanner.nextLine());
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        logger.debug("Destroying 51Degrees Listener");
        if (this.autoUpdateTimer != null) {
            this.autoUpdateTimer.cancel();
        }
        if (this.fileUpdateTimer != null) {
            this.fileUpdateTimer.cancel();
        }
        logger.debug("Destroyed 51Degrees Listener");
    }
}

