/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.webapp;

import fiftyone.mobile.detection.AutoUpdateException;
import fiftyone.mobile.detection.entities.stream.Dataset;
import fiftyone.mobile.detection.factories.StreamFactory;
import fiftyone.mobile.detection.webapp.WebProvider;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoUpdate
extends TimerTask {
    private final String masterFilePath;
    private String[] licenseKeys;
    private static final Logger logger = LoggerFactory.getLogger(AutoUpdate.class);

    public AutoUpdate(String string, List<String> list) {
        this.masterFilePath = string;
        this.licenseKeys = list.toArray(new String[list.size()]);
    }

    @Override
    public void run() {
        if (this.shouldUpdate()) {
            try {
                boolean bl = fiftyone.mobile.detection.AutoUpdate.update((String[])this.licenseKeys, (String)this.masterFilePath);
                if (bl) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("y-MMM-d");
                    File file = new File(this.masterFilePath);
                    Date date = new Date(file.lastModified());
                    String string = simpleDateFormat.format(date);
                    logger.info(String.format("Automatically updated binary data file '%s' with  version published on the '%s'.", file, string));
                    WebProvider.refresh();
                }
            }
            catch (AutoUpdateException autoUpdateException) {
                logger.warn(String.format("Exception auto updating file '%s'", this.masterFilePath), (Throwable)autoUpdateException);
            }
            catch (Exception exception) {
                logger.warn(String.format("Exception auto updating file '%s'", this.masterFilePath), (Throwable)exception);
            }
        }
    }

    private boolean shouldUpdate() {
        boolean bl = true;
        File file = new File(this.masterFilePath);
        if (file.exists()) {
            try {
                Dataset dataset = StreamFactory.create((String)this.masterFilePath, (boolean)false);
                if (dataset.getName().equals("Lite") && new Date().before(dataset.nextUpdate)) {
                    bl = false;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bl;
    }
}

