/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.webapp;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.Disposable;
import fiftyone.mobile.detection.Match;
import fiftyone.mobile.detection.Provider;
import fiftyone.mobile.detection.factories.MemoryFactory;
import fiftyone.mobile.detection.factories.StreamFactory;
import fiftyone.mobile.detection.webapp.ProfileOverride;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebProvider
extends Provider
implements Disposable {
    private static final Object lock = new Object();
    private static WebProvider activeProvider;
    private static WebProvider embeddedProvider;
    private static final Logger logger;
    private static final String RESULT_ATTIBUTE = "51D_RESULT";
    private String sourceDataFile = null;

    public WebProvider() throws IOException {
        super(60);
    }

    public WebProvider(Dataset dataset) {
        super(dataset, 60);
    }

    public void dispose() {
        File file;
        if (this.dataSet != null) {
            this.dataSet.dispose();
        }
        if (this.sourceDataFile != null && (file = new File(this.sourceDataFile)).exists()) {
            file.delete();
            logger.debug(String.format("Deleted temporary data file '%s'", this.sourceDataFile));
        }
        if (activeProvider == this) {
            activeProvider = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebProvider getEmbeddedProvider() {
        if (embeddedProvider == null) {
            Object object = lock;
            synchronized (object) {
                if (embeddedProvider == null) {
                    try {
                        embeddedProvider = new WebProvider();
                    }
                    catch (IOException iOException) {
                        logger.error("Exception creating web provider from embedded data", (Throwable)iOException);
                    }
                }
            }
        }
        return embeddedProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebProvider getActiveProvider(ServletContext servletContext) {
        if (activeProvider == null) {
            Object object = lock;
            synchronized (object) {
                if (activeProvider == null) {
                    activeProvider = WebProvider.create(servletContext);
                }
            }
        }
        return activeProvider;
    }

    static File getBinaryFilePath(ServletContext servletContext) {
        String string = servletContext.getInitParameter("BINARY_FILE_PATH");
        return string == null ? null : new File(String.format("%s\\%s", servletContext.getRealPath("WEB-INF"), string));
    }

    private static void cleanTemporaryFiles(File[] fileArray) {
        try {
            for (File file : fileArray) {
                try {
                    if (file.delete()) continue;
                    logger.debug(String.format("Could not delete temporary file '%s'. It may be in user by another provider.", file));
                }
                catch (SecurityException securityException) {
                    logger.debug(String.format("Exception deleting temporary file '%s'", file), (Throwable)securityException);
                }
            }
        }
        catch (Exception exception) {
            logger.warn("Exception cleaning temporary files", (Throwable)exception);
        }
    }

    private static void copyFile(File file, String string) throws FileNotFoundException, IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file.getAbsolutePath());
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        byte[] byArray = new byte[1026];
        while ((n = fileInputStream.read(byArray)) > 0) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        fileOutputStream.close();
    }

    private static String getTempFileName(File file, File file2) {
        return file.getAbsolutePath() + String.format("\\%s.%s.tmp", file2.getName(), UUID.randomUUID().toString());
    }

    private static String getTempWorkingFile(File file, File file2) throws FileNotFoundException, IOException {
        String string = null;
        if (file2.exists()) {
            string = WebProvider.getTempFileName(file, file2);
            WebProvider.copyFile(file2, string);
        }
        return string;
    }

    private static WebProvider create(ServletContext servletContext) {
        WebProvider webProvider = null;
        File file = new File(servletContext.getRealPath("WEB-INF"));
        boolean bl = "True".equalsIgnoreCase(servletContext.getInitParameter("MEMORY_MODE"));
        final File file2 = WebProvider.getBinaryFilePath(servletContext);
        if (file2 != null) {
            WebProvider.cleanTemporaryFiles(file.listFiles(new FilenameFilter(){
                private final String filterRegex;
                {
                    this.filterRegex = String.format("%s\\..+\\.tmp", file2.getName());
                }

                @Override
                public boolean accept(File file, String string) {
                    return string.matches(this.filterRegex);
                }
            }));
            try {
                if (file2.exists()) {
                    if (bl) {
                        logger.info(String.format("Creating memory provider from binary data file '%s'.", file2.getAbsolutePath()));
                        webProvider = new WebProvider(MemoryFactory.create((String)file2.getAbsolutePath()));
                    } else {
                        String string = WebProvider.getTempWorkingFile(file, file2);
                        logger.info(String.format("Creating stream provider from binary data file '%s'.", string));
                        webProvider = new WebProvider(StreamFactory.create((String)string));
                        webProvider.sourceDataFile = string;
                    }
                    logger.info(String.format("Created provider from binary data file '%s'.", file2.getAbsolutePath()));
                }
            }
            catch (Exception exception) {
                logger.error(String.format("Exception processing device data from binary file '%s'. Enable debug level logging and try again to help identify cause.", file2), (Throwable)exception);
                webProvider = null;
            }
        }
        if (webProvider == null || webProvider.dataSet == null) {
            webProvider = WebProvider.getEmbeddedProvider();
        }
        return webProvider;
    }

    public Match match(HttpServletRequest httpServletRequest) throws IOException {
        HashMap hashMap = new HashMap();
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Enumeration enumeration2 = httpServletRequest.getHeaders(string);
            if (!enumeration2.hasMoreElements()) continue;
            hashMap.put(string, enumeration2.nextElement());
        }
        return super.match(hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String[]> getResult(HttpServletRequest httpServletRequest) throws IOException {
        boolean bl = ProfileOverride.hasOverrides(httpServletRequest);
        Map map = (Map)httpServletRequest.getAttribute(RESULT_ATTIBUTE);
        HttpSession httpSession = httpServletRequest.getSession();
        if (map == null || bl) {
            HttpServletRequest httpServletRequest2 = httpServletRequest;
            synchronized (httpServletRequest2) {
                map = (Map)httpServletRequest.getAttribute(RESULT_ATTIBUTE);
                if (map == null || bl) {
                    Match match;
                    if (httpSession != null && !bl) {
                        map = (Map)httpSession.getAttribute(RESULT_ATTIBUTE);
                    }
                    if (map == null && (match = WebProvider.getActiveProvider(httpServletRequest.getServletContext()).match(httpServletRequest)) != null) {
                        ProfileOverride.override(httpServletRequest, match);
                        if (httpSession != null) {
                            httpSession.setAttribute(RESULT_ATTIBUTE, (Object)match.getResults());
                        }
                        httpServletRequest.setAttribute(RESULT_ATTIBUTE, (Object)match.getResults());
                        map = match.getResults();
                    }
                }
            }
        } else if (httpSession != null) {
            httpSession.setAttribute(RESULT_ATTIBUTE, (Object)map);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refresh() {
        if (activeProvider != null) {
            Object object = lock;
            synchronized (object) {
                if (activeProvider != null) {
                    WebProvider webProvider = activeProvider;
                    activeProvider = null;
                    webProvider.dispose();
                }
            }
        }
    }

    static {
        logger = LoggerFactory.getLogger(WebProvider.class);
    }

    static interface MatchResult
    extends Map<String, String[]> {
    }
}

