/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.webapp;

import fiftyone.mobile.detection.Match;
import fiftyone.mobile.detection.webapp.WebProvider;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProfileOverride {
    private static final Logger logger = LoggerFactory.getLogger(ProfileOverride.class);
    private static final String COOKIE_NAME = "51D_ProfileIds";

    ProfileOverride() {
    }

    private static String getCookieValue(HttpServletRequest httpServletRequest) {
        if (httpServletRequest.getCookies() != null) {
            for (Cookie cookie : httpServletRequest.getCookies()) {
                if (!COOKIE_NAME.equalsIgnoreCase(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    static boolean hasOverrides(HttpServletRequest httpServletRequest) {
        return ProfileOverride.getCookieValue(httpServletRequest) != null;
    }

    static String getJavascript(HttpServletRequest httpServletRequest) throws IOException {
        String[] stringArray;
        Map<String, String[]> map = WebProvider.getResult(httpServletRequest);
        if (map != null && (stringArray = map.get("JavascriptHardwareProfile")) != null) {
            StringBuilder stringBuilder = new StringBuilder("function FODPO() {{ var profileIds = new Array(); ");
            for (String string : stringArray) {
                stringBuilder.append(string).append("\r");
            }
            stringBuilder.append("document.cookie = \"51D_ProfileIds=\" + profileIds.join(\"|\"); }}");
            return stringBuilder.toString();
        }
        return null;
    }

    static void override(HttpServletRequest httpServletRequest, Match match) throws IOException {
        String string = ProfileOverride.getCookieValue(httpServletRequest);
        if (string != null) {
            for (String string2 : string.split("|")) {
                try {
                    match.updateProfile(Integer.valueOf(string2).intValue());
                }
                catch (NumberFormatException numberFormatException) {
                    logger.debug(String.format("'%s' cookie contained invalid values '%s'", COOKIE_NAME, string), (Throwable)numberFormatException);
                }
            }
        }
    }
}

