/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.webapp;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.entities.Property;
import fiftyone.mobile.detection.webapp.Bandwidth;
import fiftyone.mobile.detection.webapp.ImageOptimizer;
import fiftyone.mobile.detection.webapp.ProfileOverride;
import fiftyone.mobile.detection.webapp.WebProvider;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;

class JavascriptProvider {
    private static final int DEFAULT_BUFFER_SIZE = 10240;

    JavascriptProvider() {
    }

    static void sendJavaScript(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Dataset dataset, StringBuilder stringBuilder) throws IOException {
        httpServletResponse.reset();
        httpServletResponse.setContentType("application/x-javascript");
        httpServletResponse.setCharacterEncoding("UTF-8");
        httpServletResponse.setHeader("Vary", "User-Agent");
        httpServletResponse.setHeader("Cache-Control", "public");
        httpServletResponse.setHeader("Expires", dataset.nextUpdate.toString());
        httpServletResponse.setHeader("Last-Modified", dataset.published.toString());
        try {
            httpServletResponse.setHeader("ETag", JavascriptProvider.eTagHash(dataset, httpServletRequest));
        }
        catch (Exception exception) {
            // empty catch block
        }
        httpServletResponse.setBufferSize(10240);
        httpServletResponse.setHeader("Content-Length", Integer.toString(stringBuilder.length()));
        httpServletResponse.getOutputStream().println(stringBuilder.toString());
        httpServletResponse.getOutputStream().flush();
        httpServletResponse.getOutputStream().close();
    }

    static void sendCoreJavaScript(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string;
        String string2;
        StringBuilder stringBuilder = new StringBuilder("// Copyright 51 Degrees Mobile Experts Limited\r\n");
        String string3 = ImageOptimizer.getJavascript(httpServletRequest);
        if (string3 != null) {
            stringBuilder.append(string3);
        }
        if ((string2 = Bandwidth.getJavascript(httpServletRequest)) != null) {
            stringBuilder.append(string2);
        }
        if ((string = ProfileOverride.getJavascript(httpServletRequest)) != null) {
            stringBuilder.append(string);
        }
        JavascriptProvider.sendJavaScript(httpServletRequest, httpServletResponse, WebProvider.getActiveProvider((ServletContext)httpServletRequest.getServletContext()).dataSet, stringBuilder);
    }

    static void sendFeatureJavaScript(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        StringBuilder stringBuilder = new StringBuilder("// Copyright 51 Degrees Mobile Experts Limited\r\n");
        Dataset dataset = WebProvider.getActiveProvider((ServletContext)httpServletRequest.getServletContext()).dataSet;
        Map<String, String[]> map = WebProvider.getResult(httpServletRequest);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = httpServletRequest.getQueryString();
        if (string == null) {
            for (Property property : dataset.properties) {
                if (property.valueType == Property.PropertyValueType.JAVASCRIPT) continue;
                JavascriptProvider.getFeatureJavaScript(map, arrayList, property);
            }
        } else {
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList(string.split("&")));
            for (Property property : dataset.properties) {
                if (property.valueType == Property.PropertyValueType.JAVASCRIPT) continue;
                for (String string2 : hashSet) {
                    if (!string2.equalsIgnoreCase(property.getName())) continue;
                    JavascriptProvider.getFeatureJavaScript(map, arrayList, property);
                }
            }
        }
        stringBuilder.append(String.format("var FODF={%s};", JavascriptProvider.stringJoin(",", arrayList)));
        JavascriptProvider.sendJavaScript(httpServletRequest, httpServletResponse, WebProvider.getActiveProvider((ServletContext)httpServletRequest.getServletContext()).dataSet, stringBuilder);
    }

    private static void getFeatureJavaScript(Map<String, String[]> map, List<String> list, Property property) throws IOException {
        String[] stringArray = map.get(property.getName());
        if (stringArray != null && stringArray.length > 0) {
            switch (property.valueType) {
                case BOOL: {
                    try {
                        list.add(String.format("%s:%s", property.getName().replace("/", ""), Boolean.parseBoolean(stringArray[0]) ? "true" : "false"));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case INT: {
                    try {
                        list.add(String.format("%s:%i", property.getName(), Double.parseDouble(stringArray[0])));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                case DOUBLE: {
                    try {
                        list.add(String.format("%s:%s", property.getName(), Double.parseDouble(stringArray[0])));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                default: {
                    list.add(String.format("%s:\"%s\"", property.getName(), JavascriptProvider.stringJoin("|", stringArray)));
                }
            }
        }
    }

    private static String eTagHash(Dataset dataset, HttpServletRequest httpServletRequest) throws IOException, NoSuchAlgorithmException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeLong(dataset.published.getTime());
        dataOutputStream.writeChars(httpServletRequest.getHeader("User-Agent"));
        dataOutputStream.writeChars(httpServletRequest.getQueryString());
        return Base64.encodeBase64String((byte[])MessageDigest.getInstance("MD5").digest(byteArrayOutputStream.toByteArray()));
    }

    private static String stringJoin(String string, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static String stringJoin(String string, List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append(list.get(i));
            if (i >= list.size() - 1) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }
}

