/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.webapp;

import fiftyone.mobile.detection.webapp.Cache;
import fiftyone.mobile.detection.webapp.Size;
import fiftyone.mobile.detection.webapp.WebProvider;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ImageOptimizer {
    private static final Logger logger = LoggerFactory.getLogger(ImageOptimizer.class);
    private static final String IMAGE_MAX_WIDTH = "IMAGE_MAX_WIDTH";
    private static final String IMAGE_MAX_HEIGHT = "IMAGE_MAX_HEIGHT";
    private static final String IMAGE_FACTOR = "IMAGE_FACTOR";
    private static final String IMAGE_WIDTH_PARAM = "IMAGE_WIDTH_PARAM";
    private static final String IMAGE_HEIGHT_PARAM = "IMAGE_HEIGHT_PARAM";
    private static final String IMAGE_DEFAULT_AUTO = "IMAGE_DEFAULT_AUTO";
    private static final String EMPTY_IMAGE_RESOURCE_NAME = "E.gif";
    private static final int DEFAULT_BUFFER_SIZE = 10240;
    private static final String AUTO_STRING = "auto";
    private static final String SCREEN_PIXEL_WIDTH = "ScreenPixelsWidth";
    private static final String SCREEN_PIXEL_HEIGHT = "ScreenPixelsHeight";

    ImageOptimizer() {
    }

    private static Map<String, String> getQueryString(HttpServletRequest httpServletRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (httpServletRequest.getQueryString() != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(httpServletRequest.getQueryString(), "&", false);
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            for (String string : arrayList) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(string, "=", false);
                if (stringTokenizer2.countTokens() != 2) continue;
                hashMap.put(stringTokenizer2.nextToken(), stringTokenizer2.nextToken());
            }
        }
        return hashMap;
    }

    private static Size getRequiredSize(HttpServletRequest httpServletRequest) {
        int n = 0;
        int n2 = 0;
        Map<String, String> map = ImageOptimizer.getQueryString(httpServletRequest);
        String string = ImageOptimizer.getWidthParam(httpServletRequest);
        String string2 = ImageOptimizer.getHeightParam(httpServletRequest);
        if (map.containsKey(ImageOptimizer.getWidthParam(httpServletRequest))) {
            try {
                n = Integer.parseInt(map.get(string));
            }
            catch (NumberFormatException numberFormatException) {
                n = AUTO_STRING.equalsIgnoreCase(map.get(string)) ? ImageOptimizer.getDefaultAuto(httpServletRequest) : ImageOptimizer.getImageMaxWidth(httpServletRequest);
            }
        }
        if (map.containsKey(string2)) {
            try {
                n2 = Integer.parseInt(map.get(string2));
            }
            catch (NumberFormatException numberFormatException) {
                n2 = AUTO_STRING.equalsIgnoreCase(map.get(string2)) ? ImageOptimizer.getDefaultAuto(httpServletRequest) : ImageOptimizer.getImageMaxHeight(httpServletRequest);
            }
        }
        return new Size(n, n2);
    }

    private static void resolveHeight(int n, Size size) {
        if (size.height > n) {
            double d = (double)n / (double)size.height;
            size.height = n;
            size.width = (int)((double)size.height * d);
        }
    }

    private static void resolveWidth(int n, Size size) {
        if (size.width > n) {
            double d = (double)n / (double)size.width;
            size.width = n;
            size.height = (int)((double)size.height * d);
        }
    }

    private static void resolveSize(HttpServletRequest httpServletRequest, Size size) {
        int n = ImageOptimizer.getImageMaxWidth(httpServletRequest);
        int n2 = ImageOptimizer.getImageMaxHeight(httpServletRequest);
        if (size.width > 0 || size.height > 0) {
            if (size.height > n2 || size.width > n) {
                if (size.height > size.width) {
                    ImageOptimizer.resolveWidth(n, size);
                    ImageOptimizer.resolveHeight(n2, size);
                } else {
                    ImageOptimizer.resolveHeight(n2, size);
                    ImageOptimizer.resolveWidth(n, size);
                }
            }
            int n3 = ImageOptimizer.getFactor(httpServletRequest);
            size.height = n3 * (int)Math.floor((double)size.height / (double)n3);
            size.width = n3 * (int)Math.floor((double)size.width / (double)n3);
            if (size.height == 0 && size.width == 0) {
                size.width = n3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sendImage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        Object object;
        if ("/Empty.gif".equalsIgnoreCase(httpServletRequest.getPathInfo())) {
            ImageOptimizer.sendEmpty(httpServletResponse);
            return;
        }
        File file = new File(httpServletRequest.getServletContext().getRealPath(httpServletRequest.getPathInfo()));
        if (!file.exists()) {
            httpServletResponse.sendError(404);
            return;
        }
        Size size = ImageOptimizer.getRequiredSize(httpServletRequest);
        String string = String.format("%s/cache", httpServletRequest.getServletContext().getRealPath("WEB-INF"));
        if (size.width == 0 && size.height == 0) {
            object = WebProvider.getResult(httpServletRequest);
            try {
                if (object.get(SCREEN_PIXEL_WIDTH) != null && object.get(SCREEN_PIXEL_WIDTH).length > 0) {
                    size.width = Integer.parseInt(((String[])object.get(SCREEN_PIXEL_WIDTH))[0]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                size.width = 0;
            }
            try {
                if (object.get(SCREEN_PIXEL_HEIGHT) != null && ((String[])object.get(SCREEN_PIXEL_HEIGHT)).length > 0) {
                    size.height = Integer.parseInt(((String[])object.get(SCREEN_PIXEL_HEIGHT))[0]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                size.height = 0;
            }
            size.width = Math.max(size.width, size.height);
            size.height = 0;
        }
        ImageOptimizer.resolveSize(httpServletRequest, size);
        if (size.width > 0 || size.height > 0) {
            Closeable closeable;
            Object object2;
            object = Cache.lookup(string, file, size.width, size.height);
            logger.debug(String.format("Image processor is responding with image '%s' of width '%d' and height '%d'", file, size.width, size.height));
            if (!((File)object).exists() && ((File)object).isFile() || ((File)object).lastModified() < file.lastModified()) {
                object2 = ImageOptimizer.createBufferedImage(size.width, size.height, new FileInputStream(file));
                closeable = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)object2, "image/jpeg".equals(httpServletRequest.getServletContext().getMimeType(file.getAbsolutePath())) ? "jpg" : "png", (OutputStream)closeable);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((ByteArrayOutputStream)closeable).toByteArray());
                Cache.add(file, (File)object, size.width, size.height, byteArrayInputStream);
                byteArrayInputStream.close();
            }
            object2 = ((File)object).exists() ? object : file;
            closeable = new FileInputStream((File)object2);
            try {
                ImageOptimizer.sendResponse(httpServletResponse, (InputStream)closeable, ((File)object2).length());
            }
            finally {
                ((FileInputStream)closeable).close();
            }
        }
        object = new FileInputStream(file);
        try {
            ImageOptimizer.sendResponse(httpServletResponse, (InputStream)object, file.length());
        }
        finally {
            ((FileInputStream)object).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendResponse(HttpServletResponse httpServletResponse, InputStream inputStream, long l) throws IOException {
        httpServletResponse.reset();
        httpServletResponse.setBufferSize(10240);
        httpServletResponse.setHeader("Content-Length", String.valueOf(l));
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int n;
            bufferedOutputStream = new BufferedOutputStream((OutputStream)httpServletResponse.getOutputStream(), 10240);
            byte[] byArray = new byte[10240];
            while ((n = inputStream.read(byArray)) > 0) {
                bufferedOutputStream.write(byArray, 0, n);
            }
        }
        catch (Throwable throwable) {
            ImageOptimizer.close(bufferedOutputStream);
            throw throwable;
        }
        ImageOptimizer.close(bufferedOutputStream);
    }

    private static int getDefaultAuto(HttpServletRequest httpServletRequest) {
        return ImageOptimizer.getIntegerParameter(httpServletRequest, IMAGE_DEFAULT_AUTO, 50);
    }

    private static int getFactor(HttpServletRequest httpServletRequest) {
        return ImageOptimizer.getIntegerParameter(httpServletRequest, IMAGE_FACTOR, 1);
    }

    private static int getImageMaxHeight(HttpServletRequest httpServletRequest) {
        return ImageOptimizer.getIntegerParameter(httpServletRequest, IMAGE_MAX_HEIGHT, Integer.MAX_VALUE);
    }

    private static int getImageMaxWidth(HttpServletRequest httpServletRequest) {
        return ImageOptimizer.getIntegerParameter(httpServletRequest, IMAGE_MAX_WIDTH, Integer.MAX_VALUE);
    }

    private static String getHeightParam(HttpServletRequest httpServletRequest) {
        return ImageOptimizer.getStringParameter(httpServletRequest, IMAGE_HEIGHT_PARAM, "h");
    }

    private static String getWidthParam(HttpServletRequest httpServletRequest) {
        return ImageOptimizer.getStringParameter(httpServletRequest, IMAGE_WIDTH_PARAM, "w");
    }

    private static BufferedImage createBufferedImage(int n, int n2, InputStream inputStream) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        double d = (double)n / (double)n3;
        double d2 = (double)n2 / (double)n4;
        if (d > 0.0 && d2 > 0.0 && d <= 1.0 && d2 <= 1.0) {
            n = (int)((double)n3 * d);
            n2 = (int)((double)n4 * d2);
        } else if (d > 0.0 && d2 == 0.0 && d <= 1.0) {
            n = (int)((double)n3 * d);
            n2 = (int)((double)n4 * d);
        } else if (d == 0.0 && d2 > 0.0 && d2 <= 1.0) {
            n = (int)((double)n3 * d2);
            n2 = (int)((double)n4 * d2);
        } else {
            return bufferedImage;
        }
        if (n == 0) {
            n = 1;
        }
        if (n2 == 0) {
            n2 = 1;
        }
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, bufferedImage.getType());
        bufferedImage2.getGraphics().drawImage(bufferedImage.getScaledInstance(n, n2, 4), 0, 0, null);
        return bufferedImage2;
    }

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                logger.debug("Exception closing resource", (Throwable)iOException);
            }
        }
    }

    private static void sendEmpty(HttpServletResponse httpServletResponse) throws IOException {
        InputStream inputStream = ImageOptimizer.class.getResourceAsStream(EMPTY_IMAGE_RESOURCE_NAME);
        int n = 0;
        inputStream.mark(Integer.MAX_VALUE);
        while (inputStream.read() >= 0) {
            ++n;
        }
        inputStream.reset();
        httpServletResponse.setContentType("image/gif");
        ImageOptimizer.sendResponse(httpServletResponse, inputStream, n);
    }

    private static String getStringParameter(HttpServletRequest httpServletRequest, String string, String string2) {
        String string3 = httpServletRequest.getServletContext().getInitParameter(string);
        return string3 == null ? string2 : string3;
    }

    private static int getIntegerParameter(HttpServletRequest httpServletRequest, String string, int n) {
        String string2 = httpServletRequest.getServletContext().getInitParameter(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    static String getJavascript(HttpServletRequest httpServletRequest) throws IOException {
        String[] stringArray;
        Map<String, String[]> map = WebProvider.getResult(httpServletRequest);
        if (map != null && (stringArray = map.get("JavascriptImageOptimiser")) != null && stringArray.length == 1) {
            return stringArray[0];
        }
        return null;
    }
}

