/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.webapp;

import fiftyone.mobile.detection.webapp.Stat;
import fiftyone.mobile.detection.webapp.Stats;
import fiftyone.mobile.detection.webapp.WebProvider;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Bandwidth {
    private static final Logger logger = LoggerFactory.getLogger(Bandwidth.class);
    private static final String COOKIE_NAME = "51D_Bandwidth";
    private static final String SESSION_KEY = "51D_Stats";
    private static final String COOKIE_DELIM = "|";

    Bandwidth() {
    }

    static void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, HttpSession httpSession, Cookie[] cookieArray) {
        Stats stats = (Stats)httpSession.getAttribute(SESSION_KEY);
        if (stats == null) {
            stats = new Stats();
        }
        long l = 0L;
        for (Cookie cookie : cookieArray) {
            if (!COOKIE_NAME.equals(cookie.getName())) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(URLDecoder.decode(cookie.getValue()), COOKIE_DELIM, false);
            try {
                long noSuchElementException = Long.parseLong(stringTokenizer.nextToken());
                long l2 = Long.parseLong(stringTokenizer.nextToken());
                l = Long.parseLong(stringTokenizer.nextToken());
                long l3 = Long.parseLong(stringTokenizer.nextToken());
                int n = Integer.parseInt(stringTokenizer.nextToken());
                try {
                    Stat stat = stats.fetch(noSuchElementException);
                    if (stat == null) {
                        stats.clear();
                    } else if (!stat.isComplete()) {
                        stat.browserTimeRecieved = l2;
                        stat.browserTimeCompleted = l3;
                        stat.responseLength = n;
                    }
                    stats.removeOld();
                    httpServletRequest.setAttribute("51D_LastResponseTime", (Object)stats.getLastResponseTime());
                    httpServletRequest.setAttribute("51D_LastCompletionTime", (Object)stats.getLastCompletionTime());
                    httpServletRequest.setAttribute("51D_AverageResponseTime", (Object)stats.getAverageResponseTime());
                    httpServletRequest.setAttribute("51D_AverageCompletionTime", (Object)stats.getAverageCompletionTime());
                    httpServletRequest.setAttribute("51D_AverageBandwidth", (Object)stats.getAverageBandwidth());
                    break;
                }
                catch (NumberFormatException stat) {
                    logger.error("Error parsing 51D_Bandwidth cookie", (Throwable)stat);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                System.out.println(noSuchElementException.toString());
            }
        }
        Stat stat = new Stat();
        stat.serverTimeRecieved = System.currentTimeMillis();
        stat.requestLength = httpServletRequest.getContentLength();
        stat.browserTimeSent = l;
        stats.add(stat);
        Cookie cookie = new Cookie(COOKIE_NAME, Long.toString(stat.id));
        cookie.setPath("/");
        httpServletResponse.addCookie(cookie);
        stats.lastId = stat.id;
        stat.serverTimeSent = System.currentTimeMillis();
        httpSession.setAttribute(SESSION_KEY, (Object)stats);
    }

    static String getJavascript(HttpServletRequest httpServletRequest) throws IOException {
        String[] stringArray;
        Map<String, String[]> map = WebProvider.getResult(httpServletRequest);
        if (map != null && (stringArray = map.get("JavascriptBandwidth")) != null && stringArray.length == 1) {
            return stringArray[0];
        }
        return null;
    }
}

