/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.readers;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;

public class TrieReader {
    private ArrayList<MappedByteBuffer> _buffers;
    private final FileChannel _triFile;
    private final long _start;
    private long _position = 0L;
    private int _bufferIndex = 0;
    private long _globalPosition = 0L;

    public TrieReader(FileChannel fileChannel) throws IOException {
        int n;
        this._triFile = fileChannel;
        double d = (double)fileChannel.size() / 2.147483647E9;
        int n2 = (int)Math.ceil(d);
        this._buffers = new ArrayList(n2);
        for (long i = this._start = fileChannel.position(); i != fileChannel.size(); i += (long)n) {
            long l = fileChannel.size() - i;
            n = 0;
            n = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, i, n);
            this._buffers.add(mappedByteBuffer);
        }
    }

    public long getPos() {
        return this._globalPosition;
    }

    public void setPos(long l) {
        this._globalPosition = l;
        for (int i = 0; i < this._buffers.size(); ++i) {
            if (l > (long)this._buffers.get(i).limit()) {
                l -= (long)this._buffers.get(i).limit();
                continue;
            }
            int n = (int)l;
            this._bufferIndex = i;
            this._buffers.get(i).position(n);
            break;
        }
        this._position = l;
    }

    public short readUByte() {
        short s = 0;
        byte[] byArray = this.getValue(DataType.Byte);
        s = (short)(s | byArray[0] & 0xFF);
        return s;
    }

    public short readUByte(long l) {
        this.setPos(l);
        return this.readUByte();
    }

    public int readUShort() {
        int n = 0;
        byte[] byArray = this.getValue(DataType.Unsigned_Short);
        n |= byArray[1] & 0xFF;
        n <<= 8;
        return n |= byArray[0] & 0xFF;
    }

    public int readUShort(long l) {
        this.setPos(l);
        return this.readUShort();
    }

    public long readUInt() throws IOException {
        long l = 0L;
        byte[] byArray = this.getValue(DataType.Unsigned_Int);
        l |= (long)(byArray[3] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[2] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[1] & 0xFF);
        l <<= 8;
        if ((l |= (long)(byArray[0] & 0xFF)) > 0xFFFFFFFEL) {
            throw new IOException("readInt: value is greater then unsigned integer.");
        }
        return l;
    }

    public int readInt() throws IOException {
        int n = 0;
        byte[] byArray = this.getValue(DataType.Unsigned_Int);
        for (int i = 0; i < byArray.length; ++i) {
            n = (int)((long)n + (((long)byArray[i] & 0xFFL) << 8 * i));
        }
        return n;
    }

    public long readLong() {
        long l = 0L;
        byte[] byArray = this.getValue(DataType.Long);
        for (int i = 0; i < byArray.length; ++i) {
            l += ((long)byArray[i] & 0xFFL) << 8 * i;
        }
        return l;
    }

    public long readLong(long l) throws IOException {
        this.setPos(l);
        return this.readLong();
    }

    private byte getNextByte() {
        int n = (int)this._position;
        ++this._globalPosition;
        byte by = this._buffers.get(this._bufferIndex).get(n);
        if (this._buffers.get(this._bufferIndex).remaining() == 0) {
            ++this._bufferIndex;
            this._position = 0L;
        } else {
            ++this._position;
        }
        return by;
    }

    public byte readByte() {
        return this.getNextByte();
    }

    public byte[] readBytes(int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = this.getNextByte();
        }
        return byArray;
    }

    private byte[] getValue(DataType dataType) {
        int n;
        byte[] byArray;
        switch (dataType) {
            case Byte: {
                byArray = new byte[1];
                n = 1;
                break;
            }
            case Unsigned_Short: {
                byArray = new byte[2];
                n = 2;
                break;
            }
            case Unsigned_Int: {
                byArray = new byte[4];
                n = 4;
                break;
            }
            case Long: {
                byArray = new byte[8];
                n = 8;
                break;
            }
            default: {
                return null;
            }
        }
        for (int i = 0; i < n; ++i) {
            byArray[i] = this.getNextByte();
        }
        return byArray;
    }

    public void close() throws IOException {
        for (MappedByteBuffer mappedByteBuffer : this._buffers) {
            ((ByteBuffer)mappedByteBuffer).clear();
            mappedByteBuffer = null;
        }
        this._triFile.close();
    }

    private static enum DataType {
        Byte,
        Unsigned_Short,
        Unsigned_Int,
        Long;

    }
}

