/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.factories;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.entities.AsciiString;
import fiftyone.mobile.detection.entities.Component;
import fiftyone.mobile.detection.entities.Map;
import fiftyone.mobile.detection.entities.Node;
import fiftyone.mobile.detection.entities.Profile;
import fiftyone.mobile.detection.entities.ProfileOffset;
import fiftyone.mobile.detection.entities.Property;
import fiftyone.mobile.detection.entities.RankedSignatureIndex;
import fiftyone.mobile.detection.entities.Signature;
import fiftyone.mobile.detection.entities.Value;
import fiftyone.mobile.detection.entities.memory.MemoryFixedList;
import fiftyone.mobile.detection.entities.stream.Source;
import fiftyone.mobile.detection.entities.stream.StreamFixedList;
import fiftyone.mobile.detection.entities.stream.StreamVariableList;
import fiftyone.mobile.detection.factories.AsciiStringFactory;
import fiftyone.mobile.detection.factories.ComponentFactory;
import fiftyone.mobile.detection.factories.MapFactory;
import fiftyone.mobile.detection.factories.NodeFactory;
import fiftyone.mobile.detection.factories.ProfileFactory;
import fiftyone.mobile.detection.factories.ProfileOffsetFactory;
import fiftyone.mobile.detection.factories.PropertyFactory;
import fiftyone.mobile.detection.factories.RankedSignatureIndexFactory;
import fiftyone.mobile.detection.factories.RootNodeFactory;
import fiftyone.mobile.detection.factories.SignatureFactory;
import fiftyone.mobile.detection.factories.ValueFactory;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.FileInputStream;
import java.io.IOException;

public final class StreamFactory {
    public static Dataset create(byte[] byArray) throws IOException {
        return StreamFactory.read(new BinaryReader(byArray), new Source(byArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dataset create(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        try {
            Dataset dataset = StreamFactory.read(new BinaryReader(fileInputStream), new Source(string));
            return dataset;
        }
        catch (Exception exception) {
            Dataset dataset = null;
            return dataset;
        }
        finally {
            fileInputStream.close();
        }
    }

    static Dataset read(BinaryReader binaryReader, Source source) throws IOException {
        Dataset dataset = new Dataset(binaryReader);
        dataset.strings = new StreamVariableList<AsciiString>(dataset, binaryReader, source, new AsciiStringFactory());
        MemoryFixedList<Component> memoryFixedList = new MemoryFixedList<Component>(dataset, binaryReader, new ComponentFactory());
        dataset.components = memoryFixedList;
        MemoryFixedList<Map> memoryFixedList2 = new MemoryFixedList<Map>(dataset, binaryReader, new MapFactory());
        dataset.maps = memoryFixedList2;
        MemoryFixedList<Property> memoryFixedList3 = new MemoryFixedList<Property>(dataset, binaryReader, new PropertyFactory());
        dataset.properties = memoryFixedList3;
        dataset.values = new StreamFixedList<Value>(dataset, binaryReader, source, new ValueFactory());
        dataset.profiles = new StreamVariableList<Profile>(dataset, binaryReader, source, new ProfileFactory());
        dataset.signatures = new StreamFixedList<Signature>(dataset, binaryReader, source, new SignatureFactory(dataset));
        dataset.rankedSignatureIndexes = new StreamFixedList<RankedSignatureIndex>(dataset, binaryReader, source, new RankedSignatureIndexFactory());
        dataset.nodes = new StreamVariableList<Node>(dataset, binaryReader, source, new NodeFactory());
        MemoryFixedList<Node> memoryFixedList4 = new MemoryFixedList<Node>(dataset, binaryReader, new RootNodeFactory());
        dataset.rootNodes = memoryFixedList4;
        dataset.profileOffsets = new StreamFixedList<ProfileOffset>(dataset, binaryReader, source, new ProfileOffsetFactory());
        binaryReader.setPos(memoryFixedList.header.getStartPosition());
        memoryFixedList.read(binaryReader);
        binaryReader.setPos(memoryFixedList2.header.getStartPosition());
        memoryFixedList2.read(binaryReader);
        binaryReader.setPos(memoryFixedList3.header.getStartPosition());
        memoryFixedList3.read(binaryReader);
        binaryReader.setPos(memoryFixedList4.header.getStartPosition());
        memoryFixedList4.read(binaryReader);
        return dataset;
    }
}

