/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities.stream;

import fiftyone.mobile.detection.Disposable;
import fiftyone.mobile.detection.entities.stream.TrieSource;
import fiftyone.mobile.detection.readers.TrieReader;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingDeque;

public class TriePool
implements Disposable {
    private final Queue<TrieReader> readers = new LinkedBlockingDeque<TrieReader>();
    private final TrieSource source;

    public TriePool(TrieSource trieSource) {
        this.source = trieSource;
    }

    public TrieReader getReader() throws IOException {
        TrieReader trieReader = this.readers.poll();
        if (trieReader == null) {
            trieReader = this.source.createReader();
        }
        return trieReader;
    }

    public void release(TrieReader trieReader) {
        this.readers.add(trieReader);
    }

    @Override
    public void dispose() {
        this.source.dispose();
    }
}

