/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities.stream;

import fiftyone.mobile.detection.Disposable;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class Source
implements Disposable {
    private final FileInputStream fileInputStream;
    private final byte[] data;

    public Source(String string) throws FileNotFoundException {
        this.fileInputStream = new FileInputStream(string);
        this.data = null;
    }

    public Source(byte[] byArray) {
        this.data = byArray;
        this.fileInputStream = null;
    }

    @Override
    public void dispose() {
        try {
            this.fileInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized BinaryReader createReader() throws IOException {
        if (this.data != null) {
            return new BinaryReader(this.createByteBuffer());
        }
        return new BinaryReader(this.createMappedByteBuffer());
    }

    private ByteBuffer createByteBuffer() throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.data);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return byteBuffer;
    }

    private MappedByteBuffer createMappedByteBuffer() throws IOException {
        FileChannel fileChannel = this.fileInputStream.getChannel();
        MappedByteBuffer mappedByteBuffer = this.fileInputStream.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
        mappedByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return mappedByteBuffer;
    }
}

