/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities.stream;

import fiftyone.mobile.detection.Disposable;
import fiftyone.mobile.detection.entities.stream.Source;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingDeque;

public class Pool
implements Disposable {
    private final Queue<BinaryReader> readers = new LinkedBlockingDeque<BinaryReader>();
    private final Source source;

    Pool(Source source) {
        this.source = source;
    }

    BinaryReader getReader() throws IOException {
        BinaryReader binaryReader = this.readers.poll();
        if (binaryReader == null) {
            binaryReader = this.source.createReader();
        }
        return binaryReader;
    }

    void release(BinaryReader binaryReader) {
        this.readers.add(binaryReader);
    }

    @Override
    public void dispose() {
        this.source.dispose();
    }
}

