/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities.stream;

import fiftyone.mobile.detection.Disposable;
import fiftyone.mobile.detection.factories.BaseEntityFactory;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class Cache<T>
implements Disposable {
    ConcurrentHashMap<Integer, T> itemsActive = new ConcurrentHashMap();
    ConcurrentHashMap<Integer, T> itemsInactive = new ConcurrentHashMap();
    private final Timer cacheServiceTimer;
    AtomicInteger requests = new AtomicInteger();
    AtomicInteger misses = new AtomicInteger();
    final BaseEntityFactory<T> entityFactory;

    Cache(BaseEntityFactory<T> baseEntityFactory) {
        this.entityFactory = baseEntityFactory;
        this.cacheServiceTimer = new Timer();
        this.cacheServiceTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                ConcurrentHashMap concurrentHashMap = Cache.this.itemsInactive;
                Cache.this.itemsInactive = new ConcurrentHashMap();
                Cache.this.itemsActive = concurrentHashMap;
            }
        }, 60000L, 60000L);
    }

    void addRecent(int n, T t) {
        this.itemsInactive.put(n, t);
    }

    double getPercentageMisses() {
        return this.misses.doubleValue() / this.requests.doubleValue();
    }

    @Override
    public void dispose() {
        this.cacheServiceTimer.cancel();
    }

    static interface EntityCreator<T> {
        public T create(int var1);
    }
}

