/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities.memory;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.entities.BaseEntity;
import fiftyone.mobile.detection.entities.memory.BaseList;
import fiftyone.mobile.detection.factories.BaseEntityFactory;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.IOException;

public class MemoryVariableList<T extends BaseEntity>
extends BaseList<T> {
    public MemoryVariableList(Dataset dataset, BinaryReader binaryReader, BaseEntityFactory<T> baseEntityFactory) {
        super(dataset, binaryReader, baseEntityFactory);
    }

    public void read(BinaryReader binaryReader) throws IOException {
        int n = 0;
        for (int i = 0; i < this.header.getCount(); ++i) {
            BaseEntity baseEntity = (BaseEntity)this.entityFactory.create(this.dataSet, n, binaryReader);
            this.array.add(i, baseEntity);
            n += this.entityFactory.getLength(baseEntity);
        }
    }

    @Override
    public T get(int n) {
        return (T)((BaseEntity)this.array.get(this.binarySearch(n)));
    }

    private int binarySearch(int n) {
        int n2 = 0;
        int n3 = this.size() - 1;
        while (n2 <= n3) {
            int n4 = n2 + (n3 - n2) / 2;
            int n5 = ((BaseEntity)this.array.get(n4)).getIndex() - n;
            if (n5 == 0) {
                return n4;
            }
            if (n5 > 0) {
                n3 = n4 - 1;
                continue;
            }
            n2 = n4 + 1;
        }
        return -1;
    }
}

