/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.entities.BaseEntity;
import fiftyone.mobile.detection.entities.Component;
import fiftyone.mobile.detection.entities.Profile;
import fiftyone.mobile.detection.entities.Property;
import fiftyone.mobile.detection.entities.Signature;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;

public class Value
extends BaseEntity
implements Comparable<Value> {
    public static final int RECORD_LENGTH = 14;
    private String name;
    private final int nameIndex;
    private Signature[] signatures;
    private Profile[] profiles;
    private Property property;
    final int propertyIndex;
    private String description;
    private final int descriptionIndex;
    private URL url;
    private final int urlIndex;
    private Double asNumber;
    private Boolean asBool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() throws IOException {
        if (this.name == null) {
            Value value = this;
            synchronized (value) {
                if (this.name == null) {
                    this.name = this.getDataSet().strings.get(this.nameIndex).toString();
                }
            }
        }
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Signature[] getSignatures() throws IOException {
        if (this.signatures == null) {
            Value value = this;
            synchronized (value) {
                if (this.signatures == null) {
                    this.signatures = this.GetSignatures();
                }
            }
        }
        return this.signatures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profile[] getProfiles() throws IOException {
        if (this.profiles == null) {
            Value value = this;
            synchronized (value) {
                if (this.profiles == null) {
                    this.profiles = this.GetProfiles();
                }
            }
        }
        return this.profiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Property getProperty() throws IOException {
        if (this.property == null) {
            Value value = this;
            synchronized (value) {
                if (this.property == null) {
                    this.property = this.getDataSet().getProperties().get(this.propertyIndex);
                }
            }
        }
        return this.property;
    }

    public Component getComponent() throws IOException {
        return this.getProperty().getComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription() throws IOException {
        if (this.descriptionIndex >= 0 && this.description == null) {
            Value value = this;
            synchronized (value) {
                if (this.description == null) {
                    this.description = this.getDataSet().strings.get(this.descriptionIndex).toString();
                }
            }
        }
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getUrl() throws IOException {
        if (this.urlIndex >= 0 && this.url == null) {
            Value value = this;
            synchronized (value) {
                if (this.url == null) {
                    this.url = new URL(this.getDataSet().strings.get(this.urlIndex).toString());
                }
            }
        }
        return this.url;
    }

    public Value(Dataset dataset, int n, BinaryReader binaryReader) {
        super(dataset, n);
        this.propertyIndex = binaryReader.readInt16();
        this.nameIndex = binaryReader.readInt32();
        this.descriptionIndex = binaryReader.readInt32();
        this.urlIndex = binaryReader.readInt32();
    }

    public void init() throws IOException {
        this.name = this.getDataSet().strings.get(this.nameIndex).toString();
        this.property = this.getDataSet().getProperties().get(this.propertyIndex);
        if (this.descriptionIndex >= 0) {
            this.description = this.getDataSet().strings.get(this.descriptionIndex).toString();
        }
        if (this.urlIndex >= 0) {
            try {
                this.url = new URL(this.getDataSet().strings.get(this.urlIndex).toString());
            }
            catch (MalformedURLException malformedURLException) {
                this.url = null;
            }
        }
    }

    private Profile[] GetProfiles() throws IOException {
        ArrayList<Profile> arrayList = new ArrayList<Profile>();
        for (Profile profile : this.getComponent().getProfiles()) {
            if (this.binarySearch(profile.getValues(), this.getIndex()) < 0) continue;
            arrayList.add(profile);
        }
        return arrayList.toArray(new Profile[arrayList.size()]);
    }

    private Signature[] GetSignatures() throws IOException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Profile profile : this.getProfiles()) {
            int[] nArray = profile.getSignatureIndexes();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer n2 = nArray[i];
                int n3 = Collections.binarySearch(arrayList, n2);
                if (n3 >= 0) continue;
                arrayList.add(~n3, n2);
            }
        }
        BaseEntity[] baseEntityArray = new Signature[arrayList.size()];
        for (int i = 0; i < baseEntityArray.length; ++i) {
            baseEntityArray[i] = this.getDataSet().getSignatures().get(i);
        }
        return baseEntityArray;
    }

    @Override
    public int compareTo(Value value) {
        if (this.getDataSet() == value.getDataSet()) {
            return this.getIndex() - value.getIndex();
        }
        try {
            return this.getName().compareTo(value.getName());
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public String toString() {
        try {
            return this.getName();
        }
        catch (IOException iOException) {
            return super.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double toDouble() throws IOException {
        if (this.asNumber == null) {
            Value value = this;
            synchronized (value) {
                if (this.asNumber == null) {
                    try {
                        this.asNumber = Double.parseDouble(this.getName());
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.asNumber = this != this.getProperty().getDefaultValue() ? Double.valueOf(this.getProperty().getDefaultValue().toDouble()) : Double.valueOf(0.0);
                    }
                }
            }
        }
        return this.asNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toBool() throws IOException {
        if (this.asBool == null) {
            Value value = this;
            synchronized (value) {
                if (this.asBool == null) {
                    this.asBool = Boolean.parseBoolean(this.getName());
                }
            }
        }
        return this.asBool;
    }

    public boolean getIsDefault() throws IOException {
        Value value = this.property.getDefaultValue();
        if (value != null) {
            return this.getName() == value.getName();
        }
        return false;
    }
}

