/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.SortedList;
import fiftyone.mobile.detection.entities.BaseEntity;
import fiftyone.mobile.detection.entities.Node;
import fiftyone.mobile.detection.entities.Profile;
import fiftyone.mobile.detection.entities.Value;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Signature
extends BaseEntity
implements Comparable<Signature> {
    public final int[] nodeOffsets;
    private int[] profileOffsets;
    private Profile[] profiles = null;
    private String deviceId;
    private Value[] values;
    private int _length;
    private String stringValue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profile[] getProfiles() throws IOException {
        if (this.profiles == null) {
            Signature signature = this;
            synchronized (signature) {
                if (this.profiles == null) {
                    this.profiles = this.getProfiles(this.profileOffsets);
                }
            }
        }
        return this.profiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDeviceId() throws IOException {
        if (this.deviceId == null) {
            Signature signature = this;
            synchronized (signature) {
                if (this.deviceId == null) {
                    this.deviceId = this.initGetDeviceId();
                }
            }
        }
        return this.deviceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value[] getValues() throws IOException {
        if (this.values == null) {
            Signature signature = this;
            synchronized (signature) {
                if (this.values == null) {
                    this.values = this.initGetValues();
                }
            }
        }
        return this.values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLength() throws IOException {
        if (this._length == 0) {
            Signature signature = this;
            synchronized (signature) {
                if (this._length == 0) {
                    this._length = this.getSignatureLength();
                }
            }
        }
        return this._length;
    }

    private int getSignatureLength() throws IOException {
        Node node = this.getDataSet().nodes.get(this.nodeOffsets[this.nodeOffsets.length - 1]);
        return node.position + node.getLength() + 1;
    }

    public Signature(Dataset dataset, int n, BinaryReader binaryReader) {
        super(dataset, n);
        this.profileOffsets = this.ReadOffsets(dataset, binaryReader, dataset.getProfilesCount());
        this.nodeOffsets = this.ReadOffsets(dataset, binaryReader, dataset.getNodesCount());
    }

    private int[] ReadOffsets(Dataset dataset, BinaryReader binaryReader, int n) {
        int n2;
        binaryReader.list.clear();
        for (int i = 0; i < n; ++i) {
            n2 = binaryReader.readInt32();
            if (n2 < 0) continue;
            binaryReader.list.add(n2);
        }
        int[] nArray = new int[binaryReader.list.size()];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = binaryReader.list.get(n2);
        }
        return nArray;
    }

    public void init() throws IOException {
        this.profiles = this.getProfiles(this.profileOffsets);
        this.values = this.initGetValues();
        this.deviceId = this.initGetDeviceId();
        this.profileOffsets = null;
    }

    private String initGetDeviceId() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.getProfiles().length; ++i) {
            stringBuilder.append(this.getProfiles()[i].profileId);
            if (i >= this.getProfiles().length - 1) continue;
            stringBuilder.append("-");
        }
        return stringBuilder.toString();
    }

    public SortedList<String, List<String>> getPropertyValuesAsStrings() throws IOException {
        SortedList<String, List<String>> sortedList = new SortedList<String, List<String>>();
        for (Value value : this.getValues()) {
            if (!sortedList.containsKey(value.getProperty().getName())) {
                sortedList.add(value.getProperty().getName(), new ArrayList());
            }
            ((List)sortedList.get(value.getProperty().getName())).add(value.getName());
        }
        return sortedList;
    }

    private Value[] initGetValues() throws IOException {
        ArrayList<Value> arrayList = new ArrayList<Value>();
        for (Profile profile : this.getProfiles()) {
            arrayList.addAll(Arrays.asList(profile.getValues()));
        }
        return arrayList.toArray(new Value[arrayList.size()]);
    }

    private Profile[] getProfiles(int[] nArray) throws IOException {
        ArrayList<Profile> arrayList = new ArrayList<Profile>();
        for (int n : nArray) {
            arrayList.add(this.getDataSet().getProfiles().get(n));
        }
        return arrayList.toArray(new Profile[arrayList.size()]);
    }

    @Override
    public int compareTo(List<Node> list) {
        int n = Math.min(this.nodeOffsets.length, list.size());
        for (int i = 0; i < n; ++i) {
            int n2 = this.nodeOffsets[i] - list.get(i).getIndex();
            if (n2 == 0) continue;
            return n2;
        }
        if (this.nodeOffsets.length < list.size()) {
            return -1;
        }
        if (this.nodeOffsets.length > list.size()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareTo(Signature signature) {
        int n = Math.min(this.nodeOffsets.length, signature.nodeOffsets.length);
        for (int i = 0; i < n; ++i) {
            int n2 = this.nodeOffsets[i] - signature.nodeOffsets[i];
            if (n2 == 0) continue;
            return n2;
        }
        if (this.nodeOffsets.length < signature.nodeOffsets.length) {
            return -1;
        }
        if (this.nodeOffsets.length > signature.nodeOffsets.length) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.stringValue == null) {
            Signature signature = this;
            synchronized (signature) {
                if (this.stringValue == null) {
                    try {
                        byte[] byArray = new byte[this.getLength()];
                        for (int n : this.nodeOffsets) {
                            this.getDataSet().nodes.get(n).addCharacters(byArray);
                        }
                        for (int i = 0; i < byArray.length; ++i) {
                            if (byArray[i] != 0) continue;
                            byArray[i] = 32;
                        }
                        this.stringValue = new String(byArray, "US-ASCII");
                    }
                    catch (IOException iOException) {
                        return super.toString();
                    }
                }
            }
        }
        return this.stringValue;
    }
}

