/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.SortedList;
import fiftyone.mobile.detection.entities.BaseEntity;
import fiftyone.mobile.detection.entities.Component;
import fiftyone.mobile.detection.entities.Property;
import fiftyone.mobile.detection.entities.Signature;
import fiftyone.mobile.detection.entities.Value;
import fiftyone.mobile.detection.entities.Values;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;

public class Profile
extends BaseEntity
implements Comparable<Profile> {
    private static final Comparator<Value> propertyComparator = new Comparator<Value>(){

        @Override
        public int compare(Value value, Value value2) {
            try {
                if (value.getProperty().displayOrder < value2.getProperty().displayOrder) {
                    return 1;
                }
                if (value.getProperty().displayOrder > value2.getProperty().displayOrder) {
                    return -1;
                }
                return 0;
            }
            catch (IOException iOException) {
                return 0;
            }
        }
    };
    public final int profileId;
    private final int[] valueIndexes;
    private SortedList<String, Values> nameToValues;
    private Signature[] signatures;
    private final int[] signatureIndexes;
    private Component component;
    private final int componentIndex;
    private Value[] values;
    private Property[] properties = null;
    private String stringValue = null;
    private static final int MIN_LENGTH = 13;

    public Values getValues(String string) throws IOException {
        return this.getValues(this.getDataSet().get(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Values getValues(Property property) throws IOException {
        Object object;
        if (this.nameToValues == null) {
            object = this;
            synchronized (object) {
                if (this.nameToValues == null) {
                    this.nameToValues = new SortedList();
                }
            }
        }
        object = this.nameToValues;
        synchronized (object) {
            Values values = (Values)this.nameToValues.get(property.getName());
            if (values != null) {
                return values;
            }
            ArrayList<Value> arrayList = new ArrayList<Value>();
            for (Value value : this.getValues()) {
                if (value.getProperty() != property) continue;
                arrayList.add(value);
            }
            values = new Values(property, arrayList);
            if (values.size() == 0) {
                values = null;
            }
            this.nameToValues.add(property.getName(), values);
            return values;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Signature[] Signatures() throws IOException {
        if (this.signatures == null) {
            Profile profile = this;
            synchronized (profile) {
                if (this.signatures == null) {
                    this.signatures = this.GetSignatures();
                }
            }
        }
        return this.signatures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponent() throws IOException {
        if (this.component == null) {
            Profile profile = this;
            synchronized (profile) {
                if (this.component == null) {
                    this.component = this.getDataSet().getComponents().get(this.componentIndex);
                }
            }
        }
        return this.component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value[] getValues() throws IOException {
        if (this.values == null) {
            Profile profile = this;
            synchronized (profile) {
                if (this.values == null) {
                    this.values = this.GetValues();
                }
            }
        }
        return this.values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Property[] getProperties() throws IOException {
        if (this.properties == null) {
            Profile profile = this;
            synchronized (profile) {
                if (this.properties == null) {
                    this.properties = this.GetProperties();
                }
            }
        }
        return this.properties;
    }

    public Profile(Dataset dataset, int n, BinaryReader binaryReader) {
        super(dataset, n);
        this.componentIndex = binaryReader.readByte();
        this.profileId = binaryReader.readInt32();
        int n2 = binaryReader.readInt32();
        int n3 = binaryReader.readInt32();
        this.valueIndexes = BaseEntity.readIntegerArray(binaryReader, n2);
        this.signatureIndexes = BaseEntity.readIntegerArray(binaryReader, n3);
    }

    public void init() throws IOException {
        this.properties = this.GetProperties();
        this.values = this.GetValues();
        this.signatures = this.GetSignatures();
        this.component = this.getDataSet().getComponents().get(this.componentIndex);
    }

    private Signature[] GetSignatures() throws IOException {
        ArrayList<Signature> arrayList = new ArrayList<Signature>();
        for (int n : this.signatureIndexes) {
            arrayList.add(this.getDataSet().getSignatures().get(n));
        }
        return arrayList.toArray(new Signature[arrayList.size()]);
    }

    private Property[] GetProperties() throws IOException {
        TreeSet<Property> treeSet = new TreeSet<Property>(new Comparator<Property>(){

            @Override
            public int compare(Property property, Property property2) {
                try {
                    return property.getName().compareTo(property2.getName());
                }
                catch (IOException iOException) {
                    return 0;
                }
            }
        });
        for (Value value : this.getValues()) {
            treeSet.add(value.getProperty());
        }
        return treeSet.toArray(new Property[treeSet.size()]);
    }

    private Value[] GetValues() throws IOException {
        ArrayList<Value> arrayList = new ArrayList<Value>();
        for (int n : this.getValueIndexes()) {
            arrayList.add(this.getDataSet().getValues().get(n));
        }
        return arrayList.toArray(new Value[arrayList.size()]);
    }

    @Override
    public int compareTo(Profile profile) {
        return this.profileId - profile.profileId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.stringValue == null) {
            Profile profile = this;
            synchronized (profile) {
                if (this.stringValue == null) {
                    ArrayList<Value> arrayList = new ArrayList<Value>();
                    try {
                        for (int i = 0; i < this.getValues().length; ++i) {
                            int n;
                            Value value = this.getValues()[i];
                            if (value.getProperty().displayOrder <= 0 || value.getName().contains("Unknown") || (n = Collections.binarySearch(arrayList, value, propertyComparator)) >= 0) continue;
                            arrayList.add(~n, value);
                        }
                        if (arrayList.size() > 0) {
                            StringBuilder stringBuilder = new StringBuilder();
                            for (int i = 0; i < arrayList.size(); ++i) {
                                stringBuilder.append(((Value)arrayList.get(i)).toString());
                                if (i >= arrayList.size() - 1) continue;
                                stringBuilder.append("/");
                            }
                            this.stringValue = stringBuilder.toString();
                        } else {
                            this.stringValue = "Blank";
                        }
                    }
                    catch (IOException iOException) {
                        this.stringValue = "Blank";
                    }
                }
            }
        }
        return this.stringValue;
    }

    public int[] getValueIndexes() {
        return this.valueIndexes;
    }

    public int[] getSignatureIndexes() {
        return this.signatureIndexes;
    }

    public int getLength() {
        return 13 + this.valueIndexes.length * 4 + this.signatureIndexes.length * 4;
    }
}

