/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.entities.BaseEntity;
import fiftyone.mobile.detection.entities.Node;
import fiftyone.mobile.detection.entities.memory.BaseList;
import java.io.IOException;
import java.nio.ByteBuffer;

public class NodeIndex
extends BaseEntity
implements Comparable<NodeIndex> {
    final int relatedNodeOffset;
    final boolean isString;
    private final byte[] value;
    private byte[] characters;
    private Node node;

    byte[] getCharacters() throws IOException {
        if (this.characters != null) {
            return this.characters;
        }
        return NodeIndex.getCharacters(this.getDataSet(), this.isString, this.value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Node getNode() throws IOException {
        if (this.node != null) {
            return this.node;
        }
        if (this.getDataSet().nodes instanceof BaseList) {
            if (this.node == null) {
                NodeIndex nodeIndex = this;
                synchronized (nodeIndex) {
                    if (this.node == null) {
                        this.node = this.getDataSet().getNodes().get(this.relatedNodeOffset);
                    }
                }
            }
            return this.node;
        }
        return this.getDataSet().getNodes().get(this.relatedNodeOffset);
    }

    public NodeIndex(Dataset dataset, int n, boolean bl, byte[] byArray, int n2) {
        super(dataset, n);
        this.isString = bl;
        this.relatedNodeOffset = n2;
        this.value = byArray;
    }

    void init() throws IOException {
        this.characters = NodeIndex.getCharacters(this.getDataSet(), this.isString, this.value);
        this.node = this.getDataSet().getNodes().get(this.relatedNodeOffset);
    }

    private static byte[] getCharacters(Dataset dataset, boolean bl, byte[] byArray) throws IOException {
        if (bl) {
            return dataset.strings.get((int)Integer.reverseBytes((int)ByteBuffer.wrap((byte[])byArray).getInt())).value;
        }
        return NodeIndex.nonZeros(byArray);
    }

    private static byte[] nonZeros(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 0) continue;
            ++n;
        }
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 0) continue;
            byArray2[n2] = byArray[i];
            if (++n2 > n) break;
        }
        return byArray2;
    }

    int compareTo(byte[] byArray, int n) throws IOException {
        byte[] byArray2 = this.getCharacters();
        int n2 = byArray2.length - 1;
        int n3 = n + byArray2.length - 1;
        while (n2 >= 0) {
            int n4 = byArray2[n2] - byArray[n3];
            if (n4 != 0) {
                return n4;
            }
            --n2;
            --n3;
        }
        return 0;
    }

    @Override
    public int compareTo(NodeIndex nodeIndex) {
        try {
            return this.compareTo(nodeIndex.getCharacters(), 0);
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public String toString() {
        try {
            return String.format("{0}[{1}]", new String(this.getCharacters()), this.relatedNodeOffset);
        }
        catch (IOException iOException) {
            return super.toString();
        }
    }
}

