/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.Match;
import fiftyone.mobile.detection.entities.BaseEntity;
import fiftyone.mobile.detection.entities.NodeIndex;
import fiftyone.mobile.detection.entities.NodeNumericIndex;
import fiftyone.mobile.detection.entities.Range;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.IOException;

public class Node
extends BaseEntity
implements Comparable<Node> {
    public static final int NODE_INDEX_LENGTH = 9;
    public static final int NODE_NUMERIC_INDEX_LENGTH = 6;
    public static final int MIN_LENGTH = 20;
    private static final Range[] ranges = new Range[]{new Range(0, 10), new Range(10, 100), new Range(100, 1000), new Range(1000, Short.MAX_VALUE)};
    private final int[] signatureIndexes;
    private final NodeIndex[] children;
    private final NodeNumericIndex[] numericChildren;
    final int parentIndex;
    private final int characterStringOffset;
    public final short nextCharacterPosition;
    public final short position;
    private Node root;
    private Node parent = null;
    private byte[] characters = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getRoot() throws IOException {
        if (this.root == null) {
            Node node = this;
            synchronized (node) {
                if (this.root == null) {
                    this.root = this.getParent() == null ? this : this.getParent().getRoot();
                }
            }
        }
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Node getParent() throws IOException {
        if (this.parentIndex >= 0 && this.parent == null) {
            Node node = this;
            synchronized (node) {
                if (this.parent == null) {
                    this.parent = this.getDataSet().getNodes().get(this.parentIndex);
                }
            }
        }
        return this.parent;
    }

    boolean isComplete() {
        return this.nextCharacterPosition != Short.MIN_VALUE;
    }

    public int getLength() throws IOException {
        return this.getRoot().position - this.position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getCharacters() throws IOException {
        if (this.characters == null && this.characterStringOffset >= 0) {
            Node node = this;
            synchronized (node) {
                if (this.characters == null) {
                    this.characters = super.getDataSet().strings.get((int)this.characterStringOffset).value;
                }
            }
        }
        return this.characters;
    }

    public int[] getRankedSignatureIndexes() {
        return this.signatureIndexes;
    }

    public int getChildrenLength() {
        return this.children.length;
    }

    public int getNumericChildrenLength() {
        return this.numericChildren.length;
    }

    public Node(Dataset dataset, int n, BinaryReader binaryReader) {
        super(dataset, n);
        this.position = binaryReader.readInt16();
        this.nextCharacterPosition = binaryReader.readInt16();
        this.parentIndex = binaryReader.readInt32();
        this.characterStringOffset = binaryReader.readInt32();
        short s = binaryReader.readInt16();
        short s2 = binaryReader.readInt16();
        int n2 = binaryReader.readInt32();
        this.children = Node.readNodeIndexes(dataset, binaryReader, n + 20, s);
        this.numericChildren = Node.readNodeNumericIndexes(dataset, binaryReader, s2);
        this.signatureIndexes = BaseEntity.readIntegerArray(binaryReader, n2);
    }

    private static NodeNumericIndex[] readNodeNumericIndexes(Dataset dataset, BinaryReader binaryReader, short s) {
        NodeNumericIndex[] nodeNumericIndexArray = new NodeNumericIndex[s];
        for (int i = 0; i < nodeNumericIndexArray.length; ++i) {
            nodeNumericIndexArray[i] = new NodeNumericIndex(dataset, binaryReader.readInt16(), binaryReader.readInt32());
        }
        return nodeNumericIndexArray;
    }

    private static NodeIndex[] readNodeIndexes(Dataset dataset, BinaryReader binaryReader, int n, short s) {
        NodeIndex[] nodeIndexArray = new NodeIndex[s];
        n += 2;
        for (int i = 0; i < nodeIndexArray.length; ++i) {
            nodeIndexArray[i] = new NodeIndex(dataset, n, binaryReader.readBoolean(), binaryReader.readBytes(4), binaryReader.readInt32());
            n += 9;
        }
        return nodeIndexArray;
    }

    public void init() throws IOException {
        if (this.parentIndex >= 0) {
            this.parent = this.getDataSet().getNodes().get(this.parentIndex);
        }
        this.root = this.getParent() == null ? this : this.getParent().getRoot();
        for (NodeIndex nodeIndex : this.children) {
            nodeIndex.init();
        }
        this.getCharacters();
    }

    public Node getCompleteNumericNode(Match match) throws IOException {
        NodeNumericIndexIterator nodeNumericIndexIterator;
        Integer n;
        Node node = null;
        Node node2 = this.getNextNode(match);
        if (node2 != null) {
            node = node2.getCompleteNumericNode(match);
        }
        if (node == null && this.numericChildren.length > 0 && (n = this.getCurrentPositionAsNumeric(match)) != null && (nodeNumericIndexIterator = this.getNumericNodeIterator(n)) != null) {
            while (nodeNumericIndexIterator.hasNext()) {
                NodeNumericIndex nodeNumericIndex = nodeNumericIndexIterator.next();
                node = nodeNumericIndex.getNode().getCompleteNumericNode(match);
                if (node == null) continue;
                int n2 = Math.abs(n - nodeNumericIndex.getValue());
                if (match.getLowestScore() == null) {
                    match.setLowestScore(n2);
                    break;
                }
                match.setLowestScore(match.getLowestScore() + n2);
                break;
            }
        }
        if (node == null && this.isComplete()) {
            node = this;
        }
        return node;
    }

    private NodeNumericIndexIterator getNumericNodeIterator(int n) {
        if (n >= 0 && n <= Short.MAX_VALUE) {
            Range range = this.getRange(n);
            int n2 = super.binarySearch(this.numericChildren, n);
            if (n2 < 0) {
                n2 = ~n2 - 1;
            }
            return new NodeNumericIndexIterator(range, this.numericChildren, n, n2);
        }
        return null;
    }

    private Range getRange(int n) {
        for (Range range : ranges) {
            if (!range.inRange(n)) continue;
            return range;
        }
        throw new IllegalArgumentException("target");
    }

    private Integer getCurrentPositionAsNumeric(Match match) {
        int n;
        for (n = this.position; n >= 0 && match.getTargetUserAgentArray()[n] >= 48 && match.getTargetUserAgentArray()[n] <= 57; --n) {
        }
        if (n < this.position) {
            return this.getNumber(match.getTargetUserAgentArray(), n + 1, this.position - n);
        }
        return null;
    }

    private Integer getNumber(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = n + n2 - 1;
        int n5 = 0;
        while (n4 >= n) {
            n3 += (int)Math.pow(10.0, n5) * (byArray[n4] - 48);
            --n4;
            ++n5;
        }
        return n3;
    }

    public Node getCompleteNode(Match match) throws IOException {
        Node node = null;
        Node node2 = this.getNextNode(match);
        if (node2 != null) {
            node = node2.getCompleteNode(match);
        }
        if (node == null && this.isComplete()) {
            node = this;
        }
        return node;
    }

    Node getNextNode(Match match) throws IOException {
        int n = this.children.length - 1;
        if (n >= 0) {
            int n2 = 0;
            int n3 = n2 + (n - n2) / 2;
            int n4 = this.children[n3].getCharacters().length;
            int n5 = this.position - n4 + 1;
            while (n2 <= n) {
                n3 = n2 + (n - n2) / 2;
                if (this.children[n3].isString) {
                    match.incrStringsRead();
                }
                match.incrNodesEvaluated();
                int n6 = this.children[n3].compareTo(match.getTargetUserAgentArray(), n5);
                if (n6 == 0) {
                    return this.children[n3].getNode();
                }
                if (n6 > 0) {
                    n = n3 - 1;
                    continue;
                }
                n2 = n3 + 1;
            }
        }
        return null;
    }

    private boolean getIsOverlap(Node node) throws IOException {
        Node node2 = node.position < this.position ? node : this;
        Node node3 = node2 == this ? node : this;
        return node2.position == node3.position || node2.getRoot().position > node3.position;
    }

    public boolean getIsOverlap(Match match) throws IOException {
        for (Node node : match.getNodes()) {
            if (!this.getIsOverlap(node)) continue;
            return true;
        }
        return false;
    }

    public void addCharacters(byte[] byArray) throws IOException {
        if (this.getParent() != null) {
            byte[] byArray2 = null;
            for (NodeIndex nodeIndex : this.getParent().children) {
                if (nodeIndex.relatedNodeOffset != this.getIndex()) continue;
                byArray2 = nodeIndex.getCharacters();
                break;
            }
            for (int i = 0; i < byArray2.length; ++i) {
                byArray[this.position + i + 1] = byArray2[i];
            }
            this.getParent().addCharacters(byArray);
        }
    }

    public String toString() {
        try {
            byte[] byArray = new byte[this.getDataSet().maxUserAgentLength];
            this.addCharacters(byArray);
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] != 0) continue;
                byArray[i] = 32;
            }
            return new String(byArray);
        }
        catch (IOException iOException) {
            return super.toString();
        }
    }

    @Override
    public int compareTo(Node node) {
        return this.getIndex() - node.getIndex();
    }

    class NodeNumericIndexIterator {
        private final NodeNumericIndex[] array;
        private final int target;
        private final Range range;
        private int lowIndex;
        private int highIndex;
        private boolean lowInRange;
        private boolean highInRange;

        NodeNumericIndexIterator(Range range, NodeNumericIndex[] nodeNumericIndexArray, int n, int n2) {
            this.range = range;
            this.array = nodeNumericIndexArray;
            this.target = n;
            this.lowIndex = n2;
            this.highIndex = n2 + 1;
            this.lowInRange = this.lowIndex >= 0 && this.lowIndex < nodeNumericIndexArray.length && range.inRange(nodeNumericIndexArray[this.lowIndex].getValue());
            this.highInRange = this.highIndex < nodeNumericIndexArray.length && this.highIndex >= 0 && range.inRange(nodeNumericIndexArray[this.highIndex].getValue());
        }

        boolean hasNext() {
            return this.lowInRange || this.highInRange;
        }

        NodeNumericIndex next() {
            int n = -1;
            if (this.lowInRange && this.highInRange) {
                int n2;
                int n3 = Math.abs(this.array[this.lowIndex].getValue() - this.target);
                if (n3 <= (n2 = Math.abs(this.array[this.highIndex].getValue() - this.target))) {
                    n = this.lowIndex--;
                    this.lowInRange = this.lowIndex >= 0 && this.range.inRange(this.array[this.lowIndex].getValue());
                } else {
                    n = this.highIndex++;
                    this.highInRange = this.highIndex < this.array.length && this.range.inRange(this.array[this.highIndex].getValue());
                }
            } else if (this.lowInRange) {
                n = this.lowIndex--;
                this.lowInRange = this.lowIndex >= 0 && this.range.inRange(this.array[this.lowIndex].getValue());
            } else {
                n = this.highIndex++;
                boolean bl = this.highInRange = this.highIndex < this.array.length && this.range.inRange(this.array[this.highIndex].getValue());
            }
            if (n >= 0) {
                return this.array[n];
            }
            return null;
        }
    }
}

