/*
 * Decompiled with CFR 0.152.
 */
package com.cube.storm.ui.view.holder;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.cube.storm.UiSettings;
import com.cube.storm.ui.R;
import com.cube.storm.ui.model.list.StandardListItem;
import com.cube.storm.ui.model.property.LinkProperty;
import com.cube.storm.ui.view.ViewClickable;
import com.cube.storm.ui.view.holder.Holder;
import com.nostra13.universalimageloader.core.assist.FailReason;
import com.nostra13.universalimageloader.core.listener.ImageLoadingListener;
import com.nostra13.universalimageloader.core.listener.SimpleImageLoadingListener;
import java.util.Iterator;

public class StandardListItemHolder
extends Holder<StandardListItem>
implements ViewClickable<StandardListItem> {
    protected ImageView image;
    protected TextView title;
    protected TextView description;
    protected LinearLayout embeddedLinksContainer;

    @Override
    public View createView(ViewGroup parent) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.standard_list_item_view, parent, false);
        this.image = (ImageView)view.findViewById(R.id.image);
        this.title = (TextView)view.findViewById(R.id.title);
        this.description = (TextView)view.findViewById(R.id.description);
        this.embeddedLinksContainer = (LinearLayout)view.findViewById(R.id.embedded_links_container);
        return view;
    }

    @Override
    public void populateView(final StandardListItem model) {
        String content;
        this.image.setVisibility(8);
        if (model.getImage() != null) {
            UiSettings.getInstance().getImageLoader().displayImage(model.getImage().getSrc(), this.image, (ImageLoadingListener)new SimpleImageLoadingListener(){

                public void onLoadingComplete(String imageUri, View view, Bitmap loadedImage) {
                    if (loadedImage != null) {
                        StandardListItemHolder.this.image.setVisibility(0);
                    }
                }

                public void onLoadingFailed(String imageUri, View view, FailReason failReason) {
                    if (!imageUri.equalsIgnoreCase(model.getImage().getFallbackSrc())) {
                        UiSettings.getInstance().getImageLoader().displayImage(model.getImage().getFallbackSrc(), StandardListItemHolder.this.image, (ImageLoadingListener)this);
                    }
                }
            });
        }
        this.description.setVisibility(8);
        this.title.setVisibility(8);
        if (model.getTitle() != null && !TextUtils.isEmpty((CharSequence)(content = (String)UiSettings.getInstance().getTextProcessor().process((Object)model.getTitle().getContent())))) {
            this.title.setText((CharSequence)content);
            this.title.setVisibility(0);
        }
        if (model.getDescription() != null && !TextUtils.isEmpty((CharSequence)(content = (String)UiSettings.getInstance().getTextProcessor().process((Object)model.getDescription().getContent())))) {
            this.description.setText((CharSequence)content);
            this.description.setVisibility(0);
        }
        if (model.getEmbeddedLinks() != null) {
            this.embeddedLinksContainer.removeAllViews();
            Iterator<LinkProperty> i$ = model.getEmbeddedLinks().iterator();
            while (i$.hasNext()) {
                LinkProperty linkProperty;
                final LinkProperty property = linkProperty = i$.next();
                View embeddedLinkView = LayoutInflater.from((Context)this.embeddedLinksContainer.getContext()).inflate(R.layout.button_embedded_link, (ViewGroup)this.embeddedLinksContainer, false);
                if (embeddedLinkView == null) continue;
                Button button = (Button)embeddedLinkView.findViewById(R.id.button);
                button.setVisibility(8);
                String content2 = (String)UiSettings.getInstance().getTextProcessor().process((Object)linkProperty.getTitle().getContent());
                if (!TextUtils.isEmpty((CharSequence)content2)) {
                    button.setText((CharSequence)content2);
                    button.setVisibility(0);
                }
                button.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        UiSettings.getInstance().getLinkHandler().handleLink(v.getContext(), property);
                    }
                });
                this.embeddedLinksContainer.setVisibility(0);
                this.embeddedLinksContainer.addView((View)button);
            }
        }
    }

    @Override
    public void onClick(@NonNull StandardListItem model, @NonNull View view) {
        if (model.getLink() != null) {
            UiSettings.getInstance().getLinkHandler().handleLink(view.getContext(), model.getLink());
        }
    }
}

