/*
 * Decompiled with CFR 0.152.
 */
package com.cube.storm.ui.view.holder;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.cube.storm.UiSettings;
import com.cube.storm.ui.R;
import com.cube.storm.ui.model.list.LogoListItem;
import com.cube.storm.ui.view.holder.Holder;
import com.nostra13.universalimageloader.core.assist.FailReason;
import com.nostra13.universalimageloader.core.listener.ImageLoadingListener;
import com.nostra13.universalimageloader.core.listener.SimpleImageLoadingListener;

public class LogoListItemHolder
extends Holder<LogoListItem> {
    protected ImageView image;
    protected TextView linkTitle;

    @Override
    public View createView(ViewGroup parent) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.logo_list_item_view, parent, false);
        this.image = (ImageView)view.findViewById(R.id.image_view);
        this.linkTitle = (TextView)view.findViewById(R.id.link_title);
        return view;
    }

    @Override
    public void populateView(final LogoListItem model) {
        if (model.getImage() != null) {
            UiSettings.getInstance().getImageLoader().displayImage(model.getImage().getSrc(), this.image, (ImageLoadingListener)new SimpleImageLoadingListener(){

                public void onLoadingFailed(String imageUri, View view, FailReason failReason) {
                    UiSettings.getInstance().getImageLoader().displayImage(model.getImage().getFallbackSrc(), LogoListItemHolder.this.image);
                }
            });
        }
        if (model.getTitle() != null && !TextUtils.isEmpty((CharSequence)model.getTitle().getContent())) {
            this.linkTitle.setText((CharSequence)UiSettings.getInstance().getTextProcessor().process((Object)model.getTitle().getContent()));
            this.linkTitle.setVisibility(0);
        } else {
            this.linkTitle.setVisibility(8);
        }
    }
}

