/*
 * Decompiled with CFR 0.152.
 */
package com.cube.storm.ui.view;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import com.cube.storm.ui.R;
import com.google.android.exoplayer.util.PlayerControl;
import java.lang.ref.WeakReference;
import java.util.Formatter;
import java.util.Locale;

public class VideoControllerView
extends FrameLayout {
    private static final String TAG = "VideoControllerView";
    private PlayerControl mPlayer;
    private Context mContext;
    private ViewGroup mAnchor;
    private View mRoot;
    private ProgressBar mProgress;
    private TextView mEndTime;
    private TextView mCurrentTime;
    private boolean mShowing;
    private boolean mDragging;
    private static final int sDefaultTimeout = 3000;
    private static final int FADE_OUT = 1;
    private static final int SHOW_PROGRESS = 2;
    private boolean mUseFastForward;
    private boolean mFromXml;
    private boolean mListenersSet;
    private View.OnClickListener mNextListener;
    private View.OnClickListener mPrevListener;
    StringBuilder mFormatBuilder;
    Formatter mFormatter;
    private ImageButton mPauseButton;
    private ImageButton mFfwdButton;
    private ImageButton mRewButton;
    private ImageButton mNextButton;
    private ImageButton mPrevButton;
    private ImageButton mFullscreenButton;
    private Handler mHandler = new MessageHandler(this);
    private OnControllerVisibilityChangeListener listener;
    private View.OnClickListener mPauseListener = new View.OnClickListener(){

        public void onClick(View v) {
            VideoControllerView.this.doPauseResume();
            VideoControllerView.this.show(3000);
        }
    };
    private View.OnClickListener mFullscreenListener = new View.OnClickListener(){

        public void onClick(View v) {
            VideoControllerView.this.doToggleFullscreen();
            VideoControllerView.this.show(3000);
        }
    };
    private SeekBar.OnSeekBarChangeListener mSeekListener = new SeekBar.OnSeekBarChangeListener(){

        public void onStartTrackingTouch(SeekBar bar) {
            VideoControllerView.this.show(3600000);
            VideoControllerView.this.mDragging = true;
            VideoControllerView.this.mHandler.removeMessages(2);
        }

        public void onProgressChanged(SeekBar bar, int progress, boolean fromuser) {
            if (VideoControllerView.this.mPlayer == null) {
                return;
            }
            if (!fromuser) {
                return;
            }
            long duration = VideoControllerView.this.mPlayer.getDuration();
            long newposition = duration * (long)progress / 1000L;
            VideoControllerView.this.mPlayer.seekTo((int)newposition);
            if (VideoControllerView.this.mCurrentTime != null) {
                VideoControllerView.this.mCurrentTime.setText((CharSequence)VideoControllerView.this.stringForTime((int)newposition));
            }
        }

        public void onStopTrackingTouch(SeekBar bar) {
            VideoControllerView.this.mDragging = false;
            VideoControllerView.this.setProgress();
            VideoControllerView.this.updatePausePlay();
            VideoControllerView.this.show(3000);
            VideoControllerView.this.mHandler.sendEmptyMessage(2);
        }
    };
    private View.OnClickListener mRewListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (VideoControllerView.this.mPlayer == null) {
                return;
            }
            int pos = VideoControllerView.this.mPlayer.getCurrentPosition();
            VideoControllerView.this.mPlayer.seekTo(pos -= 5000);
            VideoControllerView.this.setProgress();
            VideoControllerView.this.show(3000);
        }
    };
    private View.OnClickListener mFfwdListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (VideoControllerView.this.mPlayer == null) {
                return;
            }
            int pos = VideoControllerView.this.mPlayer.getCurrentPosition();
            VideoControllerView.this.mPlayer.seekTo(pos += 15000);
            VideoControllerView.this.setProgress();
            VideoControllerView.this.show(3000);
        }
    };

    public VideoControllerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mRoot = null;
        this.mContext = context;
        this.mUseFastForward = true;
        this.mFromXml = true;
        Log.i((String)TAG, (String)TAG);
    }

    public VideoControllerView(Context context, boolean useFastForward) {
        super(context);
        this.mContext = context;
        this.mUseFastForward = useFastForward;
        Log.i((String)TAG, (String)TAG);
    }

    public VideoControllerView(Context context) {
        this(context, true);
        Log.i((String)TAG, (String)TAG);
    }

    public void setOnControllerVisibilityChangeListener(OnControllerVisibilityChangeListener listener) {
        this.listener = listener;
    }

    public void onFinishInflate() {
        if (this.mRoot != null) {
            this.initControllerView(this.mRoot);
        }
    }

    public void setMediaPlayer(PlayerControl player) {
        this.mPlayer = player;
        this.updatePausePlay();
        this.updateFullScreen();
    }

    public void setAnchorView(ViewGroup view) {
        this.mAnchor = view;
        FrameLayout.LayoutParams frameParams = new FrameLayout.LayoutParams(-1, -1);
        this.removeAllViews();
        View v = this.makeControllerView();
        this.addView(v, (ViewGroup.LayoutParams)frameParams);
    }

    protected View makeControllerView() {
        LayoutInflater inflate = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        this.mRoot = inflate.inflate(R.layout.media_controller, null);
        this.initControllerView(this.mRoot);
        return this.mRoot;
    }

    private void initControllerView(View v) {
        this.mPauseButton = (ImageButton)v.findViewById(R.id.pause);
        if (this.mPauseButton != null) {
            this.mPauseButton.requestFocus();
            this.mPauseButton.setOnClickListener(this.mPauseListener);
        }
        this.mFullscreenButton = (ImageButton)v.findViewById(R.id.fullscreen);
        if (this.mFullscreenButton != null) {
            this.mFullscreenButton.requestFocus();
            this.mFullscreenButton.setOnClickListener(this.mFullscreenListener);
        }
        this.mFfwdButton = (ImageButton)v.findViewById(R.id.ffwd);
        if (this.mFfwdButton != null) {
            this.mFfwdButton.setOnClickListener(this.mFfwdListener);
            if (!this.mFromXml) {
                this.mFfwdButton.setVisibility(this.mUseFastForward ? 0 : 8);
            }
        }
        this.mRewButton = (ImageButton)v.findViewById(R.id.rew);
        if (this.mRewButton != null) {
            this.mRewButton.setOnClickListener(this.mRewListener);
            if (!this.mFromXml) {
                this.mRewButton.setVisibility(this.mUseFastForward ? 0 : 8);
            }
        }
        this.mNextButton = (ImageButton)v.findViewById(R.id.next);
        if (this.mNextButton != null && !this.mFromXml && !this.mListenersSet) {
            this.mNextButton.setVisibility(8);
        }
        this.mPrevButton = (ImageButton)v.findViewById(R.id.prev);
        if (this.mPrevButton != null && !this.mFromXml && !this.mListenersSet) {
            this.mPrevButton.setVisibility(8);
        }
        this.mProgress = (ProgressBar)v.findViewById(R.id.mediacontroller_progress);
        if (this.mProgress != null) {
            if (this.mProgress instanceof SeekBar) {
                SeekBar seeker = (SeekBar)this.mProgress;
                seeker.setOnSeekBarChangeListener(this.mSeekListener);
            }
            this.mProgress.setMax(1000);
        }
        this.mEndTime = (TextView)v.findViewById(R.id.time);
        this.mCurrentTime = (TextView)v.findViewById(R.id.time_current);
        this.mFormatBuilder = new StringBuilder();
        this.mFormatter = new Formatter(this.mFormatBuilder, Locale.getDefault());
        this.installPrevNextListeners();
    }

    public void show() {
        this.show(3000);
    }

    private void disableUnsupportedButtons() {
        if (this.mPlayer == null) {
            return;
        }
        try {
            if (this.mPauseButton != null && !this.mPlayer.canPause()) {
                this.mPauseButton.setEnabled(false);
            }
            if (this.mRewButton != null && !this.mPlayer.canSeekBackward()) {
                this.mRewButton.setEnabled(false);
            }
            if (this.mFfwdButton != null && !this.mPlayer.canSeekForward()) {
                this.mFfwdButton.setEnabled(false);
            }
        }
        catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            // empty catch block
        }
    }

    public void show(int timeout) {
        if (!this.mShowing && this.mAnchor != null) {
            this.setProgress();
            if (this.mPauseButton != null) {
                this.mPauseButton.requestFocus();
            }
            this.disableUnsupportedButtons();
            FrameLayout.LayoutParams tlp = new FrameLayout.LayoutParams(-1, -2, 80);
            this.mAnchor.addView((View)this, (ViewGroup.LayoutParams)tlp);
            this.mShowing = true;
        }
        this.updatePausePlay();
        this.updateFullScreen();
        if (this.listener != null) {
            this.listener.onShow();
        }
        this.mHandler.sendEmptyMessage(2);
        Message msg = this.mHandler.obtainMessage(1);
        if (timeout != 0) {
            this.mHandler.removeMessages(1);
            this.mHandler.sendMessageDelayed(msg, (long)timeout);
        }
    }

    public boolean isShowing() {
        return this.mShowing;
    }

    public void hide() {
        if (this.mAnchor == null) {
            return;
        }
        try {
            this.mAnchor.removeView((View)this);
            this.mHandler.removeMessages(2);
        }
        catch (IllegalArgumentException ex) {
            Log.w((String)"MediaController", (String)"already removed");
        }
        this.mShowing = false;
        if (this.listener != null) {
            this.listener.onHide();
        }
    }

    private String stringForTime(int timeMs) {
        int totalSeconds = timeMs / 1000;
        int seconds = totalSeconds % 60;
        int minutes = totalSeconds / 60 % 60;
        int hours = totalSeconds / 3600;
        this.mFormatBuilder.setLength(0);
        if (hours > 0) {
            return this.mFormatter.format("%d:%02d:%02d", hours, minutes, seconds).toString();
        }
        return this.mFormatter.format("%02d:%02d", minutes, seconds).toString();
    }

    private int setProgress() {
        if (this.mPlayer == null || this.mDragging) {
            return 0;
        }
        int position = this.mPlayer.getCurrentPosition();
        int duration = this.mPlayer.getDuration();
        if (this.mProgress != null) {
            if (duration > 0) {
                long pos = 1000L * (long)position / (long)duration;
                this.mProgress.setProgress((int)pos);
            }
            int percent = this.mPlayer.getBufferPercentage();
            this.mProgress.setSecondaryProgress(percent * 10);
        }
        if (this.mEndTime != null) {
            this.mEndTime.setText((CharSequence)this.stringForTime(duration));
        }
        if (this.mCurrentTime != null) {
            this.mCurrentTime.setText((CharSequence)this.stringForTime(position));
        }
        return position;
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.show(3000);
        return true;
    }

    public boolean onTrackballEvent(MotionEvent ev) {
        this.show(3000);
        return false;
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        boolean uniqueDown;
        if (this.mPlayer == null) {
            return true;
        }
        int keyCode = event.getKeyCode();
        boolean bl = uniqueDown = event.getRepeatCount() == 0 && event.getAction() == 0;
        if (keyCode == 79 || keyCode == 85 || keyCode == 62) {
            if (uniqueDown) {
                this.doPauseResume();
                this.show(3000);
                if (this.mPauseButton != null) {
                    this.mPauseButton.requestFocus();
                }
            }
            return true;
        }
        if (keyCode == 126) {
            if (uniqueDown && !this.mPlayer.isPlaying()) {
                this.mPlayer.start();
                this.updatePausePlay();
                this.show(3000);
            }
            return true;
        }
        if (keyCode == 86 || keyCode == 127) {
            if (uniqueDown && this.mPlayer.isPlaying()) {
                this.mPlayer.pause();
                this.updatePausePlay();
                this.show(3000);
            }
            return true;
        }
        if (keyCode == 25 || keyCode == 24 || keyCode == 164) {
            return super.dispatchKeyEvent(event);
        }
        if (keyCode == 4 || keyCode == 82) {
            if (uniqueDown) {
                this.hide();
            }
            return true;
        }
        this.show(3000);
        return super.dispatchKeyEvent(event);
    }

    public void updatePausePlay() {
        if (this.mRoot == null || this.mPauseButton == null || this.mPlayer == null) {
            return;
        }
        if (this.mPlayer.isPlaying()) {
            this.mPauseButton.setImageResource(R.drawable.ic_media_pause);
        } else {
            this.mPauseButton.setImageResource(R.drawable.ic_media_play);
        }
    }

    public void updateFullScreen() {
        if (this.mRoot == null || this.mFullscreenButton == null || this.mPlayer == null) {
            return;
        }
    }

    private void doPauseResume() {
        if (this.mPlayer == null) {
            return;
        }
        if (this.mPlayer.isPlaying()) {
            this.mPlayer.pause();
        } else {
            this.mPlayer.start();
        }
        this.updatePausePlay();
    }

    private void doToggleFullscreen() {
        if (this.mPlayer == null) {
            return;
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.mPauseButton != null) {
            this.mPauseButton.setEnabled(enabled);
        }
        if (this.mFfwdButton != null) {
            this.mFfwdButton.setEnabled(enabled);
        }
        if (this.mRewButton != null) {
            this.mRewButton.setEnabled(enabled);
        }
        if (this.mNextButton != null) {
            this.mNextButton.setEnabled(enabled && this.mNextListener != null);
        }
        if (this.mPrevButton != null) {
            this.mPrevButton.setEnabled(enabled && this.mPrevListener != null);
        }
        if (this.mProgress != null) {
            this.mProgress.setEnabled(enabled);
        }
        this.disableUnsupportedButtons();
        super.setEnabled(enabled);
    }

    private void installPrevNextListeners() {
        if (this.mNextButton != null) {
            this.mNextButton.setOnClickListener(this.mNextListener);
            this.mNextButton.setEnabled(this.mNextListener != null);
        }
        if (this.mPrevButton != null) {
            this.mPrevButton.setOnClickListener(this.mPrevListener);
            this.mPrevButton.setEnabled(this.mPrevListener != null);
        }
    }

    public void setPrevNextListeners(View.OnClickListener next, View.OnClickListener prev) {
        this.mNextListener = next;
        this.mPrevListener = prev;
        this.mListenersSet = true;
        if (this.mRoot != null) {
            this.installPrevNextListeners();
            if (this.mNextButton != null && !this.mFromXml) {
                this.mNextButton.setVisibility(0);
            }
            if (this.mPrevButton != null && !this.mFromXml) {
                this.mPrevButton.setVisibility(0);
            }
        }
    }

    private static class MessageHandler
    extends Handler {
        private final WeakReference<VideoControllerView> mView;

        MessageHandler(VideoControllerView view) {
            this.mView = new WeakReference<VideoControllerView>(view);
        }

        public void handleMessage(Message msg) {
            VideoControllerView view = (VideoControllerView)((Object)this.mView.get());
            if (view == null || view.mPlayer == null) {
                return;
            }
            switch (msg.what) {
                case 1: {
                    view.hide();
                    if (view.listener == null) break;
                    view.listener.onHide();
                    break;
                }
                case 2: {
                    int pos = view.setProgress();
                    if (view.mDragging || !view.mShowing || !view.mPlayer.isPlaying()) break;
                    msg = this.obtainMessage(2);
                    this.sendMessageDelayed(msg, 1000 - pos % 1000);
                }
            }
        }
    }

    public static interface MediaPlayerControl {
        public void start();

        public void pause();

        public int getDuration();

        public int getCurrentPosition();

        public void seekTo(int var1);

        public boolean isPlaying();

        public int getBufferPercentage();

        public boolean canPause();

        public boolean canSeekBackward();

        public boolean canSeekForward();

        public boolean isFullScreen();

        public void toggleFullScreen();
    }

    public static interface OnControllerVisibilityChangeListener {
        public void onHide();

        public void onShow();
    }
}

