/*
 * Decompiled with CFR 0.152.
 */
package com.cube.storm.ui.lib.helper;

import android.net.Uri;
import android.os.Build;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import net.callumtaylor.asynchttp.AsyncHttpClient;
import net.callumtaylor.asynchttp.response.AsyncHttpResponseHandler;
import net.callumtaylor.asynchttp.response.StringResponseHandler;

public class YouTubeHelper {
    public static void getStreamingUrl(String youtubeUrl, final Callback callback) {
        String videoId;
        Uri uri = Uri.parse((String)youtubeUrl);
        if (uri.getHost().endsWith("youtube.com")) {
            videoId = uri.getQueryParameter("v");
        } else if (uri.getHost().contains("yout")) {
            videoId = (String)uri.getPathSegments().get(0);
        } else {
            return;
        }
        AsyncHttpClient client = new AsyncHttpClient("http://www.youtube.com/");
        client.get("get_video_info?video_id=" + videoId, (AsyncHttpResponseHandler)new StringResponseHandler(){
            private String streamingUrl;

            public void onFinish(boolean failed) {
                if (failed || TextUtils.isEmpty((CharSequence)this.streamingUrl)) {
                    callback.onFailed(this.getContent());
                } else {
                    callback.onStreamingUrlFetched(this.streamingUrl);
                }
            }

            public void onSuccess() {
                try {
                    String response = this.getContent();
                    if (response != null) {
                        String[] parts = response.split("&");
                        String streamMap = "";
                        for (String part : parts) {
                            if (!part.contains("url_encoded_fmt_stream_map")) continue;
                            streamMap = part;
                            break;
                        }
                        boolean allowWebm = Build.VERSION.SDK_INT >= 14;
                        String disallow = "video/x-flv";
                        streamMap = streamMap.replace("url_encoded_fmt_stream_map=", "");
                        streamMap = Uri.decode((String)streamMap);
                        String[] streamParts = streamMap.split(",");
                        String url = null;
                        for (String streamPart : streamParts) {
                            String[] streamPartSections = streamPart.split("&");
                            ArrayMap map = new ArrayMap();
                            for (String streamPartSection : streamPartSections) {
                                String[] mapParts = streamPartSection.split("=");
                                map.put((Object)mapParts[0], (Object)mapParts[1]);
                            }
                            if (Uri.decode((String)((String)map.get((Object)"type"))).contains(disallow) || !allowWebm && Uri.decode((String)((String)map.get((Object)"type"))).contains("video/webm")) continue;
                            if (((String)map.get((Object)"quality")).equals("medium")) {
                                url = Uri.decode((String)((String)map.get((Object)"url"))) + "&signature=" + (String)map.get((Object)"sig");
                                break;
                            }
                            if (!((String)map.get((Object)"quality")).equals("small")) continue;
                            url = Uri.decode((String)((String)map.get((Object)"url"))) + "&signature=" + (String)map.get((Object)"sig");
                            break;
                        }
                        this.streamingUrl = url;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static interface Callback {
        public void onStreamingUrlFetched(String var1);

        public void onFailed(String var1);
    }
}

