/*
 * Decompiled with CFR 0.152.
 */
package com.cube.storm.ui.lib.factory;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.cube.storm.UiSettings;
import com.cube.storm.ui.activity.StormActivity;
import com.cube.storm.ui.activity.StormWebActivity;
import com.cube.storm.ui.activity.VideoPlayerActivity;
import com.cube.storm.ui.data.FragmentIntent;
import com.cube.storm.ui.fragment.StormListFragment;
import com.cube.storm.ui.fragment.StormTabbedFragment;
import com.cube.storm.ui.model.App;
import com.cube.storm.ui.model.Model;
import com.cube.storm.ui.model.descriptor.PageDescriptor;
import com.cube.storm.ui.model.descriptor.VideoPageDescriptor;
import com.cube.storm.ui.model.descriptor.WebPageDescriptor;
import com.cube.storm.ui.model.page.ListPage;
import com.cube.storm.ui.model.page.Page;
import com.cube.storm.ui.model.page.PageCollection;
import com.cube.storm.ui.model.page.TabbedPageCollection;
import java.io.Serializable;

public abstract class IntentFactory {
    @Deprecated
    @Nullable
    public FragmentIntent getFragmentIntentForPage(@NonNull Page pageData) {
        Bundle arguments = new Bundle();
        arguments.putSerializable("stormui.page", (Serializable)pageData);
        if (pageData instanceof ListPage) {
            FragmentIntent intent = new FragmentIntent(StormListFragment.class, pageData.getTitle() != null ? pageData.getTitle().getContent() : "", arguments);
            return intent;
        }
        return null;
    }

    @Deprecated
    @Nullable
    public Intent getIntentForPage(@NonNull Context context, @NonNull Page pageData) {
        Bundle arguments = new Bundle();
        arguments.putSerializable("stormui.page", (Serializable)pageData);
        if (pageData instanceof ListPage) {
            Intent intent = new Intent(context, StormActivity.class);
            intent.putExtras(arguments);
            return intent;
        }
        return null;
    }

    @Nullable
    public FragmentIntent getFragmentIntentForPageUri(@NonNull Uri pageUri) {
        App app = UiSettings.getInstance().getApp();
        if (app != null) {
            for (PageDescriptor pageDescriptor : app.getMap()) {
                if (!pageUri.toString().equalsIgnoreCase(pageDescriptor.getSrc())) continue;
                return this.getFragmentIntentForPageDescriptor(pageDescriptor);
            }
        } else {
            Page page = UiSettings.getInstance().getViewBuilder().buildPage(pageUri);
            if (page != null) {
                return this.getFragmentIntentForPage(page);
            }
        }
        return null;
    }

    @Nullable
    public Intent geIntentForPageUri(@NonNull Context context, @NonNull Uri pageUri) {
        App app = UiSettings.getInstance().getApp();
        if (app != null) {
            for (PageDescriptor pageDescriptor : app.getMap()) {
                if (!pageUri.toString().equalsIgnoreCase(pageDescriptor.getSrc())) continue;
                return this.getIntentForPageDescriptor(context, pageDescriptor);
            }
        } else {
            Page page = UiSettings.getInstance().getViewBuilder().buildPage(pageUri);
            if (page != null) {
                return this.getIntentForPage(context, page);
            }
        }
        return null;
    }

    @Nullable
    public FragmentIntent getFragmentIntentForPageDescriptor(@NonNull PageDescriptor pageDescriptor) {
        Class<? extends Model> pageType = UiSettings.getInstance().getViewFactory().getModelForView(pageDescriptor.getType());
        if (pageType != null) {
            Bundle arguments = new Bundle();
            arguments.putString("stormui.uri", pageDescriptor.getSrc());
            if (ListPage.class.isAssignableFrom(pageType)) {
                FragmentIntent intent = new FragmentIntent(StormListFragment.class, null, arguments);
                return intent;
            }
            if (TabbedPageCollection.class.isAssignableFrom(pageType)) {
                FragmentIntent intent = new FragmentIntent(StormTabbedFragment.class, null, arguments);
                return intent;
            }
        }
        return null;
    }

    @Nullable
    public Intent getIntentForPageDescriptor(@NonNull Context context, @NonNull PageDescriptor pageDescriptor) {
        Bundle arguments = new Bundle();
        Class<? extends Model> pageType = UiSettings.getInstance().getViewFactory().getModelForView(pageDescriptor.getType());
        arguments.putString("stormui.uri", pageDescriptor.getSrc());
        if (pageDescriptor instanceof VideoPageDescriptor || UiSettings.getInstance().getLinkHandler().isYoutubeVideo(Uri.parse((String)pageDescriptor.getSrc())) || UiSettings.getInstance().getLinkHandler().isVideo(Uri.parse((String)pageDescriptor.getSrc()))) {
            Intent intent = new Intent(context, VideoPlayerActivity.class);
            intent.putExtras(arguments);
            return intent;
        }
        if (pageDescriptor instanceof WebPageDescriptor) {
            Intent intent = new Intent(context, StormWebActivity.class);
            intent.putExtra("extra_file_name", pageDescriptor.getSrc());
            return intent;
        }
        if (pageType != null && (Page.class.isAssignableFrom(pageType) || PageCollection.class.isAssignableFrom(pageType))) {
            Intent intent = new Intent(context, StormActivity.class);
            intent.putExtras(arguments);
            return intent;
        }
        return null;
    }
}

