/*
 * Decompiled with CFR 0.152.
 */
package com.cube.storm.ui.lib.adapter;

import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v13.app.FragmentPagerAdapter;
import android.text.TextUtils;
import com.cube.storm.UiSettings;
import com.cube.storm.ui.data.FragmentIntent;
import com.cube.storm.ui.data.FragmentPackage;
import com.cube.storm.ui.model.descriptor.TabbedPageDescriptor;
import com.cube.storm.ui.model.property.ImageProperty;
import com.cube.storm.ui.view.PagerSlidingTabStrip;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StormPageAdapter
extends FragmentPagerAdapter
implements PagerSlidingTabStrip.IconTabProvider {
    protected final Context context;
    protected final FragmentManager manager;
    protected int index = 0;
    private List<FragmentPackage> pages = new ArrayList<FragmentPackage>(0);

    public StormPageAdapter(Context context, FragmentManager manager) {
        super(manager);
        this.context = context;
        this.manager = manager;
    }

    public void setPages(@NonNull Collection<FragmentPackage> pages) {
        this.pages = new ArrayList<FragmentPackage>(pages.size());
        this.pages.addAll(pages);
    }

    public Fragment getItem(int index) {
        FragmentIntent intent = this.pages.get(index).getFragmentIntent();
        return Fragment.instantiate((Context)this.context, (String)intent.getFragment().getName(), (Bundle)intent.getArguments());
    }

    public CharSequence getPageTitle(int position) {
        FragmentPackage fragmentPackage = this.pages.get(position % this.pages.size());
        if (fragmentPackage.getPageDescriptor() instanceof TabbedPageDescriptor && ((TabbedPageDescriptor)fragmentPackage.getPageDescriptor()).getTabBarItem().getTitle() != null) {
            return (CharSequence)UiSettings.getInstance().getTextProcessor().process((Object)((TabbedPageDescriptor)fragmentPackage.getPageDescriptor()).getTabBarItem().getTitle().getContent());
        }
        String tabName = "";
        if (!TextUtils.isEmpty((CharSequence)fragmentPackage.getPageDescriptor().getName())) {
            tabName = fragmentPackage.getPageDescriptor().getName();
        }
        return (CharSequence)UiSettings.getInstance().getTextProcessor().process((Object)tabName);
    }

    @Override
    public int getPageIconResId(int position) {
        return 0;
    }

    @Override
    public Bitmap getPageIconBitmap(int position) {
        FragmentPackage fragmentPackage = this.pages.get(position % this.pages.size());
        Bitmap image = null;
        if (fragmentPackage.getPageDescriptor() instanceof TabbedPageDescriptor && ((TabbedPageDescriptor)fragmentPackage.getPageDescriptor()).getTabBarItem().getImage() != null) {
            ImageProperty imageProperty = ((TabbedPageDescriptor)fragmentPackage.getPageDescriptor()).getTabBarItem().getImage();
            image = UiSettings.getInstance().getImageLoader().loadImageSync(imageProperty.getSrc());
            if (image == null && !TextUtils.isEmpty((CharSequence)imageProperty.getFallbackSrc())) {
                image = UiSettings.getInstance().getImageLoader().loadImageSync(imageProperty.getFallbackSrc());
            }
            return image;
        }
        return null;
    }

    public int getCount() {
        return this.pages.size();
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public List<FragmentPackage> getPages() {
        return this.pages;
    }
}

