/*
 * Decompiled with CFR 0.152.
 */
package com.cube.storm.ui.controller.adapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.cube.storm.UiSettings;
import com.cube.storm.ui.model.Model;
import com.cube.storm.ui.model.list.Divider;
import com.cube.storm.ui.model.list.List;
import com.cube.storm.ui.view.ViewClickable;
import com.cube.storm.ui.view.holder.Holder;
import java.util.ArrayList;
import java.util.Collection;

public class StormListAdapter
extends BaseAdapter {
    private ArrayList<Model> items = new ArrayList();
    private ArrayList<Class<? extends Holder>> itemTypes = new ArrayList();
    private Context context;

    public StormListAdapter(Context context) {
        this.context = context;
    }

    public StormListAdapter(Context context, Collection<? extends Model> items) {
        this.context = context;
        this.setItems(items);
    }

    public void setItems(@Nullable Collection<? extends Model> items) {
        if (items != null) {
            this.items = new ArrayList(items.size());
            this.itemTypes = new ArrayList(items.size() / 2);
            for (Model model : items) {
                this.addItem(model);
            }
        } else {
            this.items = new ArrayList(0);
            this.itemTypes = new ArrayList(0);
        }
    }

    public void addItem(@NonNull Model item) {
        this.addItem(this.items.size(), item);
    }

    public void addItem(int index, @NonNull Model item) {
        if (item instanceof List) {
            boolean addDivider = false;
            if (((List)item).getHeader() != null && !TextUtils.isEmpty((CharSequence)((CharSequence)UiSettings.getInstance().getTextProcessor().process((Object)((List)item).getHeader().getContent())))) {
                List.ListHeader header = new List.ListHeader();
                header.setHeader(((List)item).getHeader());
                this.addItem(header);
                addDivider = true;
            }
            if (((List)item).getChildren() != null) {
                for (Model model : ((List)item).getChildren()) {
                    if (model == null) continue;
                    this.addItem(model);
                }
            }
            if (((List)item).getFooter() != null && !TextUtils.isEmpty((CharSequence)((CharSequence)UiSettings.getInstance().getTextProcessor().process((Object)((List)item).getFooter().getContent())))) {
                List.ListFooter footer = new List.ListFooter();
                footer.setFooter(((List)item).getFooter());
                this.addItem(footer);
                addDivider = true;
            }
            if (addDivider) {
                this.addItem(new Divider());
            }
        } else {
            Class<? extends Holder> holderClass = UiSettings.getInstance().getViewFactory().getHolderForView(item.getClassName());
            if (holderClass != null) {
                this.items.add(index, item);
            }
            if (!this.itemTypes.contains(holderClass)) {
                this.itemTypes.add(holderClass);
            }
        }
    }

    public int getCount() {
        return this.items.size();
    }

    public Model getItem(int position) {
        return this.items.get(position);
    }

    public long getItemId(int position) {
        return this.getItem(position).hashCode();
    }

    public boolean isEnabled(int position) {
        return ViewClickable.class.isAssignableFrom(this.itemTypes.get(this.getItemViewType(position)));
    }

    public int getViewTypeCount() {
        return Math.max(1, this.itemTypes.size());
    }

    public int getItemViewType(int position) {
        Model view = this.items.get(position);
        return this.itemTypes.indexOf(UiSettings.getInstance().getViewFactory().getHolderForView(view.getClassName()));
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        Model model = this.getItem(position);
        Holder holder = null;
        if (convertView != null) {
            holder = (Holder)convertView.getTag();
        } else {
            try {
                holder = this.itemTypes.get(this.getItemViewType(position)).newInstance();
                convertView = holder.createView(parent);
                convertView.setTag((Object)holder);
            }
            catch (Exception e) {
                throw new InstantiationError("Could not instantiate a new holder for model " + model.getClassName());
            }
        }
        if (holder != null) {
            holder.populateView(model);
        }
        return convertView;
    }
}

