/*
 * Decompiled with CFR 0.152.
 */
package com.cube.storm.ui.view.holder;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.cube.storm.UiSettings;
import com.cube.storm.ui.R;
import com.cube.storm.ui.model.list.StandardListItem;
import com.cube.storm.ui.view.ViewClickable;
import com.cube.storm.ui.view.holder.Holder;
import com.nostra13.universalimageloader.core.assist.FailReason;
import com.nostra13.universalimageloader.core.listener.ImageLoadingListener;
import com.nostra13.universalimageloader.core.listener.SimpleImageLoadingListener;

public class StandardListItemHolder
extends Holder<StandardListItem>
implements ViewClickable<StandardListItem> {
    protected ImageView image;
    protected TextView title;
    protected TextView description;

    @Override
    public View createView(ViewGroup parent) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.standard_list_item_view, parent, false);
        this.image = (ImageView)view.findViewById(R.id.image);
        this.title = (TextView)view.findViewById(R.id.title);
        this.description = (TextView)view.findViewById(R.id.description);
        return view;
    }

    @Override
    public void populateView(final StandardListItem model) {
        if (model.getImage() != null) {
            UiSettings.getInstance().getImageLoader().displayImage(model.getImage().getSrc(), this.image, (ImageLoadingListener)new SimpleImageLoadingListener(){

                public void onLoadingFailed(String imageUri, View view, FailReason failReason) {
                    UiSettings.getInstance().getImageLoader().displayImage(model.getImage().getFallbackSrc(), StandardListItemHolder.this.image);
                }
            });
        }
        if (model.getTitle() != null) {
            this.title.setText((CharSequence)UiSettings.getInstance().getTextProcessor().process((Object)model.getTitle().getContent()));
        }
        if (model.getDescription() != null && !TextUtils.isEmpty((CharSequence)model.getDescription().getContent())) {
            this.description.setText((CharSequence)UiSettings.getInstance().getTextProcessor().process((Object)model.getDescription().getContent()));
            this.description.setVisibility(0);
        } else {
            this.description.setVisibility(8);
        }
    }

    @Override
    public void onClick(@NonNull StandardListItem model, @NonNull View view) {
        if (model.getLink() != null) {
            UiSettings.getInstance().getLinkHandler().handleLink(view.getContext(), model.getLink());
        }
    }
}

