/*
 * Decompiled with CFR 0.152.
 */
package com.cube.storm.ui.lib.adapter;

import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v13.app.FragmentPagerAdapter;
import com.cube.storm.ui.data.FragmentIntent;
import com.cube.storm.ui.data.FragmentPackage;
import com.cube.storm.ui.model.descriptor.TabbedPageDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StormPageAdapter
extends FragmentPagerAdapter {
    protected final Context context;
    protected final FragmentManager manager;
    protected int index = 0;
    private List<FragmentPackage> pages = new ArrayList<FragmentPackage>(0);

    public StormPageAdapter(Context context, FragmentManager manager) {
        super(manager);
        this.context = context;
        this.manager = manager;
    }

    public void setPages(@NonNull Collection<FragmentPackage> pages) {
        this.pages = new ArrayList<FragmentPackage>(pages.size());
        this.pages.addAll(pages);
    }

    public Fragment getItem(int index) {
        FragmentIntent intent = this.pages.get(index).getFragmentIntent();
        return Fragment.instantiate((Context)this.context, (String)intent.getFragment().getName(), (Bundle)intent.getArguments());
    }

    public CharSequence getPageTitle(int position) {
        FragmentPackage fragmentPackage = this.pages.get(position % this.pages.size());
        if (fragmentPackage.getPageDescriptor() instanceof TabbedPageDescriptor && ((TabbedPageDescriptor)fragmentPackage.getPageDescriptor()).getTabBarItem().getTitle() != null) {
            return ((TabbedPageDescriptor)fragmentPackage.getPageDescriptor()).getTabBarItem().getTitle().getContent();
        }
        return fragmentPackage.getPageDescriptor().getName();
    }

    public int getCount() {
        return this.pages.size();
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public List<FragmentPackage> getPages() {
        return this.pages;
    }
}

