/*
 * Decompiled with CFR 0.152.
 */
package com.cube.storm.ui.data;

import android.content.Context;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;

public enum ContentDensity {
    x0_75(0.75, "x0.75"),
    x1_00(1.0, "x1.0"),
    x1_50(1.5, "x1.5"),
    x2_00(2.0, "x2.0");

    double maxPixels;
    String density;

    private ContentDensity(double maxPixels, String densityStr) {
        this.maxPixels = maxPixels;
        this.density = densityStr;
    }

    public static ContentDensity getDensityForSize(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        WindowManager window = (WindowManager)context.getSystemService("window");
        Display display = window.getDefaultDisplay();
        display.getMetrics(displayMetrics);
        int densityName = displayMetrics.densityDpi;
        if (densityName >= 120 && densityName < 160) {
            return x0_75;
        }
        if (densityName >= 160 && densityName < 213) {
            return x1_00;
        }
        if (densityName >= 213 && densityName < 320) {
            return x1_50;
        }
        if (densityName >= 320) {
            return x2_00;
        }
        return x1_00;
    }

    public double getMaxPixels() {
        return this.maxPixels;
    }

    public String getDensity() {
        return this.density;
    }
}

