/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.transformation.AbstractSAXTransformer;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.dom.DOMBuilder;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.xerces.parsers.AbstractSAXParser;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.cyberneko.html.HTMLConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class NekoHTMLTransformer
extends AbstractSAXTransformer
implements Configurable {
    private Properties properties;
    private Map tags;

    public void endElement(String uri, String name, String raw) throws SAXException {
        if (this.tags.containsKey(name)) {
            String toBeNormalized = this.endTextRecording();
            try {
                this.normalize(toBeNormalized);
            }
            catch (ProcessingException e) {
                e.printStackTrace();
            }
        }
        super.endElement(uri, name, raw);
    }

    public void startElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        super.startElement(uri, name, raw, attr);
        if (this.tags.containsKey(name)) {
            this.startTextRecording();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void configure(Configuration config) throws ConfigurationException {
        super.configure(config);
        String configUrl = config.getChild("neko-config").getValue(null);
        if (configUrl == null) return;
        SourceResolver resolver = null;
        Source configSource = null;
        try {
            try {
                resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
                configSource = resolver.resolveURI(configUrl);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Loading configuration from " + configSource.getURI());
                }
                this.properties = new Properties();
                this.properties.load(configSource.getInputStream());
            }
            catch (Exception e) {
                this.getLogger().warn("Cannot load configuration from " + configUrl);
                throw new ConfigurationException("Cannot load configuration from " + configUrl, (Throwable)e);
            }
            Object var7_5 = null;
            if (null == resolver) return;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (null == resolver) throw throwable;
            this.manager.release((Object)resolver);
            resolver.release(configSource);
            throw throwable;
        }
        this.manager.release((Object)resolver);
        resolver.release(configSource);
    }

    private void normalize(String text) throws ProcessingException {
        try {
            HtmlSaxParser parser = new HtmlSaxParser(this.properties);
            ByteArrayInputStream bais = new ByteArrayInputStream(text.getBytes());
            DOMBuilder builder = new DOMBuilder();
            parser.setContentHandler((ContentHandler)builder);
            parser.parse(new InputSource(bais));
            Document doc = builder.getDocument();
            IncludeXMLConsumer.includeNode((Node)doc, (ContentHandler)this.contentHandler, (LexicalHandler)this.lexicalHandler);
        }
        catch (Exception e) {
            throw new ProcessingException("Exception in NekoHTMLTransformer.normalize()", (Throwable)e);
        }
    }

    public void setup(org.apache.cocoon.environment.SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        String tagsParam = par.getParameter("tags", "");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("tags: " + tagsParam);
        }
        this.tags = new HashMap();
        StringTokenizer tokenizer = new StringTokenizer(tagsParam, ",");
        while (tokenizer.hasMoreElements()) {
            String tok = tokenizer.nextToken().trim();
            this.tags.put(tok, tok);
        }
    }

    public static class HtmlSaxParser
    extends AbstractSAXParser {
        public HtmlSaxParser(Properties properties) {
            super((XMLParserConfiguration)HtmlSaxParser.getConfig(properties));
        }

        private static HTMLConfiguration getConfig(Properties properties) {
            HTMLConfiguration config = new HTMLConfiguration();
            config.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"lower");
            if (properties != null) {
                Iterator<Object> i = properties.keySet().iterator();
                while (i.hasNext()) {
                    String name = (String)i.next();
                    if (name.indexOf("/features/") > -1) {
                        config.setFeature(name, Boolean.getBoolean(properties.getProperty(name)));
                        continue;
                    }
                    if (name.indexOf("/properties/") <= -1) continue;
                    config.setProperty(name, (Object)properties.getProperty(name));
                }
            }
            return config;
        }
    }
}

