/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractSAXTransformer;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CleanupTransformer
extends AbstractSAXTransformer
implements CacheableProcessingComponent {
    private static final char[] INDENT = "\n                                                                                                                                                                ".toCharArray();
    private static final int MAX_INDENT = INDENT.length - 1;
    private boolean allowAllURIs = false;
    private Set allowedURIs = new HashSet();
    private Set inlineElements = new HashSet();
    private LinkedList uriPrefixes = new LinkedList();
    private int indentSize = 2;
    private int numIndents = 0;
    private String lastElement = null;

    public void configure(Configuration conf) throws ConfigurationException {
        Configuration inlineEltChild = conf.getChild("inline-elements");
        StringTokenizer st = new StringTokenizer(inlineEltChild.getValue(""), ",");
        this.inlineElements.clear();
        while (st.hasMoreTokens()) {
            String nextElement = st.nextToken().trim();
            if (nextElement.length() <= 0) continue;
            this.inlineElements.add(nextElement);
        }
        this.allowAllURIs = false;
        Configuration[] uriChildren = conf.getChildren("preserve-uri");
        int i = 0;
        while (i < uriChildren.length) {
            String nextChild = uriChildren[i].getValue("").trim();
            if (nextChild.length() != 0) {
                if (nextChild.equals("*")) {
                    this.allowAllURIs = true;
                    break;
                }
                this.allowedURIs.add(nextChild);
            }
            ++i;
        }
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.indentSize = par.getParameterAsInteger("indent-size", 2);
    }

    public void recycle() {
        super.recycle();
        this.numIndents = 0;
        this.lastElement = null;
    }

    public Serializable getKey() {
        return Integer.toString(this.indentSize);
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.allowAllURIs) {
            this.contentHandler.startPrefixMapping(prefix, uri);
        } else if (this.allowedURIs.contains(uri)) {
            this.contentHandler.startPrefixMapping(prefix, uri);
            this.uriPrefixes.add(prefix);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.allowAllURIs) {
            this.contentHandler.endPrefixMapping(prefix);
        } else if (!this.uriPrefixes.isEmpty() && this.uriPrefixes.getLast().toString().equals(prefix)) {
            this.contentHandler.endPrefixMapping(prefix);
            this.uriPrefixes.removeLast();
        }
    }

    public void startElement(String uri, String qName, String lName, Attributes attrs) throws SAXException {
        if (!this.inlineElements.contains(qName)) {
            int indentSize = this.indentSize * this.numIndents % MAX_INDENT;
            this.contentHandler.ignorableWhitespace(INDENT, 0, indentSize + 1);
            ++this.numIndents;
            this.lastElement = qName;
        }
        this.contentHandler.startElement(uri, qName, lName, attrs);
    }

    public void endElement(String uri, String qName, String lName) throws SAXException {
        if (!this.inlineElements.contains(qName)) {
            --this.numIndents;
            if (this.lastElement == null || !this.lastElement.equals(qName)) {
                int indentSize = this.indentSize * this.numIndents % MAX_INDENT;
                this.contentHandler.ignorableWhitespace(INDENT, 0, indentSize + 1);
            }
            this.lastElement = null;
        }
        this.contentHandler.endElement(uri, qName, lName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        int end = start + length;
        int i = start;
        while (i < end) {
            if (!Character.isWhitespace(ch[i])) {
                this.contentHandler.characters(ch, start, length);
                return;
            }
            ++i;
        }
        this.contentHandler.characters(INDENT, 1, 1);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }
}

