/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.util.PostInputStream;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;
import org.xml.sax.SAXException;

public class HTMLGenerator
extends ServiceableGenerator
implements Configurable,
CacheableProcessingComponent,
Disposable {
    public static final String FORM_NAME = "form-name";
    private Source inputSource;
    private InputStream requestStream;
    private String xpath = null;
    private XPathProcessor processor = null;
    private Properties properties;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this.processor = (XPathProcessor)this.manager.lookup(XPathProcessor.ROLE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void configure(Configuration config) throws ConfigurationException {
        String configUrl = config.getChild("jtidy-config").getValue(null);
        if (configUrl == null) return;
        SourceResolver resolver = null;
        Source configSource = null;
        try {
            try {
                resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
                configSource = resolver.resolveURI(configUrl);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Loading configuration from " + configSource.getURI());
                }
                this.properties = new Properties();
                this.properties.load(configSource.getInputStream());
            }
            catch (Exception e) {
                this.getLogger().warn("Cannot load configuration from " + configUrl);
                throw new ConfigurationException("Cannot load configuration from " + configUrl, (Throwable)e);
            }
            Object var7_5 = null;
            if (null == resolver) return;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (null == resolver) throw throwable;
            this.manager.release((Object)resolver);
            resolver.release(configSource);
            throw throwable;
        }
        this.manager.release((Object)resolver);
        resolver.release(configSource);
    }

    public void recycle() {
        if (this.inputSource != null) {
            this.resolver.release(this.inputSource);
            this.inputSource = null;
            this.requestStream = null;
        }
        this.xpath = null;
        super.recycle();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setup(org.apache.cocoon.environment.SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        if (src == null) {
            String contentType = request.getContentType();
            if (contentType == null) {
                throw new IOException("Content-type was not specified for this request");
            }
            if (contentType.startsWith("application/x-www-form-urlencoded") || contentType.startsWith("multipart/form-data")) {
                String requested = this.parameters.getParameter(FORM_NAME, null);
                if (requested == null) {
                    throw new ProcessingException("HtmlGenerator with no \"src\" parameter expects a sitemap parameter called 'form-name' for handling form data");
                }
                String sXml = request.getParameter(requested);
                this.requestStream = new ByteArrayInputStream(sXml.getBytes());
            } else {
                if (!contentType.startsWith("text/plain") && !contentType.startsWith("text/xml") && !contentType.startsWith("application/xml")) throw new IOException("Unexpected getContentType(): " + request.getContentType());
                HttpServletRequest httpRequest = (HttpServletRequest)objectModel.get("httprequest");
                if (httpRequest == null) {
                    throw new ProcessingException("This functionality only works in an http environment.");
                }
                int len = request.getContentLength();
                if (len <= 0) throw new IOException("getContentLen() == 0");
                this.requestStream = new PostInputStream((InputStream)httpRequest.getInputStream(), len);
            }
        }
        this.xpath = request.getParameter("xpath");
        if (this.xpath == null) {
            this.xpath = par.getParameter("xpath", null);
        }
        if (par.getParameterAsBoolean("copy-parameters", false) && request.getQueryString() != null) {
            StringBuffer query = new StringBuffer(this.source);
            query.append(this.source.indexOf("?") == -1 ? (char)'?' : '&');
            query.append(request.getQueryString());
            this.source = query.toString();
        }
        try {
            if (this.source == null) return;
            this.inputSource = resolver.resolveURI(this.source);
            return;
        }
        catch (SourceException se) {
            throw SourceUtil.handle((String)("Unable to resolve " + this.source), (SourceException)se);
        }
    }

    public Serializable getKey() {
        if (this.inputSource == null) {
            return null;
        }
        if (this.xpath != null) {
            StringBuffer buffer = new StringBuffer(this.inputSource.getURI());
            buffer.append(':').append(this.xpath);
            return buffer.toString();
        }
        return this.inputSource.getURI();
    }

    public SourceValidity getValidity() {
        if (this.inputSource == null) {
            return null;
        }
        return this.inputSource.getValidity();
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        try {
            Tidy tidy = new Tidy();
            tidy.setXmlOut(true);
            if (this.properties == null) {
                tidy.setXHTML(true);
            } else {
                tidy.setConfigurationFromProps(this.properties);
            }
            tidy.setShowWarnings(this.getLogger().isWarnEnabled());
            tidy.setQuiet(!this.getLogger().isInfoEnabled());
            StringWriter stringWriter = new StringWriter();
            PrintWriter errorWriter = new PrintWriter(stringWriter);
            tidy.setErrout(errorWriter);
            if (this.inputSource != null) {
                this.requestStream = this.inputSource.getInputStream();
            }
            Document doc = tidy.parseDOM((InputStream)new BufferedInputStream(this.requestStream), null);
            XMLUtils.stripDuplicateAttributes((Node)doc, null);
            errorWriter.flush();
            errorWriter.close();
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn(stringWriter.toString());
            }
            DOMStreamer domStreamer = new DOMStreamer(this.contentHandler, this.lexicalHandler);
            this.contentHandler.startDocument();
            if (this.xpath != null) {
                NodeList nl = this.processor.selectNodeList((Node)doc, this.xpath);
                int length = nl.getLength();
                for (int i = 0; i < length; ++i) {
                    domStreamer.stream(nl.item(i));
                }
            } else {
                domStreamer.stream((Node)doc.getDocumentElement());
            }
            this.contentHandler.endDocument();
        }
        catch (IOException e) {
            throw new ResourceNotFoundException("Could not get resource " + this.inputSource.getURI(), (Throwable)e);
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessingException("Exception in HTMLGenerator.generate()", (Throwable)e);
        }
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.processor);
            this.manager = null;
        }
        this.processor = null;
        super.dispose();
    }
}

