/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.transformation.AbstractSAXTransformer;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.tidy.Tidy;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class HTMLTransformer
extends AbstractSAXTransformer
implements Configurable {
    private Properties properties;
    private Map tags;

    public void endElement(String uri, String name, String raw) throws SAXException {
        if (this.tags.containsKey(name)) {
            String toBeNormalized = this.endTextRecording();
            try {
                this.normalize(toBeNormalized);
            }
            catch (ProcessingException e) {
                e.printStackTrace();
            }
        }
        super.endElement(uri, name, raw);
    }

    public void startElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        super.startElement(uri, name, raw, attr);
        if (this.tags.containsKey(name)) {
            this.startTextRecording();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void configure(Configuration config) throws ConfigurationException {
        String configUrl = config.getChild("jtidy-config").getValue(null);
        if (configUrl == null) return;
        SourceResolver resolver = null;
        Source configSource = null;
        try {
            try {
                resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
                configSource = resolver.resolveURI(configUrl);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Loading configuration from " + configSource.getURI());
                }
                this.properties = new Properties();
                this.properties.load(configSource.getInputStream());
            }
            catch (Exception e) {
                this.getLogger().warn("Cannot load configuration from " + configUrl);
                throw new ConfigurationException("Cannot load configuration from " + configUrl, (Throwable)e);
            }
            Object var7_5 = null;
            if (null == resolver) return;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (null == resolver) throw throwable;
            this.manager.release((Object)resolver);
            resolver.release(configSource);
            throw throwable;
        }
        this.manager.release((Object)resolver);
        resolver.release(configSource);
    }

    private void normalize(String text) throws ProcessingException {
        try {
            Tidy tidy = new Tidy();
            tidy.setXmlOut(true);
            if (this.properties == null) {
                tidy.setXHTML(true);
            } else {
                tidy.setConfigurationFromProps(this.properties);
            }
            tidy.setShowWarnings(this.getLogger().isWarnEnabled());
            tidy.setQuiet(!this.getLogger().isInfoEnabled());
            StringWriter stringWriter = new StringWriter();
            PrintWriter errorWriter = new PrintWriter(stringWriter);
            tidy.setErrout(errorWriter);
            ByteArrayInputStream bais = new ByteArrayInputStream(text.getBytes());
            Document doc = tidy.parseDOM((InputStream)new BufferedInputStream(bais), null);
            XMLUtils.stripDuplicateAttributes((Node)doc, null);
            errorWriter.flush();
            errorWriter.close();
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn(stringWriter.toString());
            }
            IncludeXMLConsumer.includeNode((Node)doc, (ContentHandler)this.contentHandler, (LexicalHandler)this.lexicalHandler);
        }
        catch (Exception e) {
            throw new ProcessingException("Exception in HTMLTransformer.normalize()", (Throwable)e);
        }
    }

    public void setup(org.apache.cocoon.environment.SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        String tagsParam = par.getParameter("tags", "");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("tags: " + tagsParam);
        }
        this.tags = new HashMap();
        StringTokenizer tokenizer = new StringTokenizer(tagsParam, ",");
        while (tokenizer.hasMoreElements()) {
            String tok = tokenizer.nextToken().trim();
            this.tags.put(tok, tok);
        }
    }
}

