/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logging.logback;

import ch.qos.logback.classic.pattern.ThrowableHandlingConverter;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.encoder.EncoderBase;
import co.elastic.logging.AdditionalField;
import co.elastic.logging.EcsJsonSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Marker;

public class EcsEncoder
extends EncoderBase<ILoggingEvent> {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private boolean stackTraceAsArray = false;
    private String serviceName;
    private String serviceVersion;
    private String serviceEnvironment;
    private String serviceNodeName;
    private String eventDataset;
    private boolean includeMarkers = false;
    private ThrowableHandlingConverter throwableConverter = null;
    private final ThrowableProxyConverter throwableProxyConverter = new ThrowableProxyConverter();
    private boolean includeOrigin;
    private final List<AdditionalField> additionalFields = new ArrayList<AdditionalField>();
    private OutputStream os;
    protected Layout<ILoggingEvent> messageLayout;

    public byte[] headerBytes() {
        return null;
    }

    public void start() {
        super.start();
        this.throwableProxyConverter.start();
        if (this.throwableConverter != null) {
            this.throwableConverter.start();
        }
        this.eventDataset = EcsJsonSerializer.computeEventDataset((String)this.eventDataset, (String)this.serviceName);
    }

    public void init(OutputStream os) {
        this.os = os;
    }

    public void doEncode(Object event) throws IOException {
        this.os.write(this.encode((ILoggingEvent)event));
        this.os.flush();
    }

    public void close() throws IOException {
    }

    public byte[] encode(ILoggingEvent event) {
        StackTraceElement[] callerData;
        StringBuilder builder = new StringBuilder(256);
        EcsJsonSerializer.serializeObjectStart((StringBuilder)builder, (long)event.getTimeStamp());
        EcsJsonSerializer.serializeLogLevel((StringBuilder)builder, (String)event.getLevel().toString());
        this.serializeMessage(event, builder);
        EcsJsonSerializer.serializeEcsVersion((StringBuilder)builder);
        this.serializeMarkers(event, builder);
        EcsJsonSerializer.serializeServiceName((StringBuilder)builder, (String)this.serviceName);
        EcsJsonSerializer.serializeServiceVersion((StringBuilder)builder, (String)this.serviceVersion);
        EcsJsonSerializer.serializeServiceEnvironment((StringBuilder)builder, (String)this.serviceEnvironment);
        EcsJsonSerializer.serializeServiceNodeName((StringBuilder)builder, (String)this.serviceNodeName);
        EcsJsonSerializer.serializeEventDataset((StringBuilder)builder, (String)this.eventDataset);
        EcsJsonSerializer.serializeThreadName((StringBuilder)builder, (String)event.getThreadName());
        EcsJsonSerializer.serializeLoggerName((StringBuilder)builder, (String)event.getLoggerName());
        EcsJsonSerializer.serializeAdditionalFields((StringBuilder)builder, this.additionalFields);
        EcsJsonSerializer.serializeMDC((StringBuilder)builder, (Map)event.getMDCPropertyMap());
        if (this.includeOrigin && (callerData = event.getCallerData()) != null && callerData.length > 0) {
            EcsJsonSerializer.serializeOrigin((StringBuilder)builder, (StackTraceElement)callerData[0]);
        }
        this.addCustomFields(event, builder);
        IThrowableProxy throwableProxy = event.getThrowableProxy();
        if (throwableProxy != null) {
            if (this.throwableConverter != null) {
                EcsJsonSerializer.serializeException((StringBuilder)builder, (String)throwableProxy.getClassName(), (CharSequence)throwableProxy.getMessage(), (CharSequence)this.throwableConverter.convert((Object)event), (boolean)this.stackTraceAsArray);
            } else if (throwableProxy instanceof ThrowableProxy) {
                EcsJsonSerializer.serializeException((StringBuilder)builder, (Throwable)((ThrowableProxy)throwableProxy).getThrowable(), (boolean)this.stackTraceAsArray);
            } else {
                EcsJsonSerializer.serializeException((StringBuilder)builder, (String)throwableProxy.getClassName(), (CharSequence)throwableProxy.getMessage(), (CharSequence)this.throwableProxyConverter.convert(event), (boolean)this.stackTraceAsArray);
            }
        }
        EcsJsonSerializer.serializeObjectEnd((StringBuilder)builder);
        return builder.toString().getBytes(UTF_8);
    }

    private void serializeMessage(ILoggingEvent event, StringBuilder builder) {
        if (this.messageLayout == null) {
            EcsJsonSerializer.serializeFormattedMessage((StringBuilder)builder, (String)event.getFormattedMessage());
        } else {
            EcsJsonSerializer.serializeFormattedMessage((StringBuilder)builder, (String)this.messageLayout.doLayout((Object)event));
        }
    }

    protected void addCustomFields(ILoggingEvent event, StringBuilder builder) {
    }

    private void serializeMarkers(ILoggingEvent event, StringBuilder builder) {
        Marker marker = event.getMarker();
        if (this.includeMarkers && marker != null) {
            EcsJsonSerializer.serializeTagStart((StringBuilder)builder);
            this.serializeMarker(builder, marker);
            EcsJsonSerializer.serializeTagEnd((StringBuilder)builder);
        }
    }

    private void serializeMarker(StringBuilder builder, Marker marker) {
        if (marker != null) {
            EcsJsonSerializer.serializeSingleTag((StringBuilder)builder, (String)marker.getName());
            Iterator it = marker.iterator();
            while (it.hasNext()) {
                this.serializeMarker(builder, (Marker)it.next());
            }
        }
    }

    public byte[] footerBytes() {
        return null;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setServiceVersion(String serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    public void setServiceEnvironment(String serviceEnvironment) {
        this.serviceEnvironment = serviceEnvironment;
    }

    public void setServiceNodeName(String serviceNodeName) {
        this.serviceNodeName = serviceNodeName;
    }

    public void setIncludeMarkers(boolean includeMarkers) {
        this.includeMarkers = includeMarkers;
    }

    public void setStackTraceAsArray(boolean stackTraceAsArray) {
        this.stackTraceAsArray = stackTraceAsArray;
    }

    public void setIncludeOrigin(boolean includeOrigin) {
        this.includeOrigin = includeOrigin;
    }

    public void addAdditionalField(AdditionalField pair) {
        this.additionalFields.add(pair);
    }

    public void setEventDataset(String eventDataset) {
        this.eventDataset = eventDataset;
    }

    public void setThrowableConverter(ThrowableHandlingConverter throwableConverter) {
        this.throwableConverter = throwableConverter;
    }

    public void setMessageLayout(Layout<ILoggingEvent> messageLayout) {
        this.messageLayout = messageLayout;
    }
}

