/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json.jackson;

import co.elastic.clients.json.BufferingJsonGenerator;
import co.elastic.clients.json.BufferingJsonpMapper;
import co.elastic.clients.json.DelegatingJsonGenerator;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpDeserializerBase;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpMapperBase;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.jackson.Jackson3JsonProvider;
import co.elastic.clients.json.jackson.Jackson3JsonpGenerator;
import co.elastic.clients.json.jackson.Jackson3JsonpParser;
import co.elastic.clients.json.jackson.Jackson3Utils;
import com.fasterxml.jackson.annotation.JsonInclude;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonParser;
import java.lang.reflect.Type;
import java.util.EnumSet;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.json.JsonMapper;

public class Jackson3JsonpMapper
extends JsonpMapperBase
implements BufferingJsonpMapper {
    private final Jackson3JsonProvider provider;
    private final JsonMapper objectMapper;

    private Jackson3JsonpMapper(JsonMapper objectMapper, Jackson3JsonProvider provider) {
        this.objectMapper = objectMapper;
        this.provider = provider;
    }

    public Jackson3JsonpMapper(JsonMapper objectMapper) {
        this.objectMapper = Jackson3JsonpMapper.configure(objectMapper);
        this.provider = new Jackson3JsonProvider(this);
    }

    public Jackson3JsonpMapper() {
        this(((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT})).changeDefaultPropertyInclusion(p -> p.withValueInclusion(JsonInclude.Include.NON_NULL))).build());
    }

    private static JsonMapper configure(JsonMapper builder) {
        return ((JsonMapper.Builder)((JsonMapper.Builder)builder.rebuild().enable(new DeserializationFeature[]{DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_TRAILING_TOKENS})).build();
    }

    @Override
    public <T> JsonpMapper withAttribute(String name, T value) {
        return new Jackson3JsonpMapper(this.objectMapper, this.provider).addAttribute(name, value);
    }

    public JsonMapper objectMapper() {
        return this.objectMapper;
    }

    @Override
    public JsonProvider jsonProvider() {
        return this.provider;
    }

    @Override
    protected <T> JsonpDeserializer<T> getDefaultDeserializer(Type type) {
        return new JacksonValueParser(type);
    }

    @Override
    public <T> void serialize(T value, jakarta.json.stream.JsonGenerator generator) {
        JsonpSerializer<T> serializer = Jackson3JsonpMapper.findSerializer(value);
        if (serializer != null) {
            serializer.serialize(value, generator, this);
            return;
        }
        while (generator instanceof DelegatingJsonGenerator) {
            generator = ((DelegatingJsonGenerator)generator).unwrap();
        }
        if (!(generator instanceof Jackson3JsonpGenerator)) {
            throw new IllegalArgumentException("Jackson's ObjectMapper can only be used with the JacksonJsonpProvider");
        }
        JsonGenerator jkGenerator = ((Jackson3JsonpGenerator)generator).jacksonGenerator();
        try {
            this.objectMapper.writeValue(jkGenerator, value);
        }
        catch (JacksonException e) {
            throw Jackson3Utils.convertException(e);
        }
    }

    @Override
    public BufferingJsonGenerator createBufferingGenerator() {
        return new Jackson3JsonpGenerator.Buffering(this);
    }

    private class JacksonValueParser<T>
    extends JsonpDeserializerBase<T> {
        private final Type type;

        protected JacksonValueParser(Type type) {
            super(EnumSet.allOf(JsonParser.Event.class));
            this.type = type;
        }

        @Override
        public T deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            if (!(parser instanceof Jackson3JsonpParser)) {
                throw new IllegalArgumentException("Jackson's ObjectMapper can only be used with the JacksonJsonpProvider");
            }
            tools.jackson.core.JsonParser jkParser = ((Jackson3JsonpParser)parser).jacksonParser();
            try {
                return (T)Jackson3JsonpMapper.this.objectMapper.readValue(jkParser, Jackson3JsonpMapper.this.objectMapper().constructType(this.type));
            }
            catch (JacksonException e) {
                throw Jackson3Utils.convertException(e);
            }
        }
    }
}

