/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SecurityRolesDlsBitSetCache
implements JsonpSerializable {
    private final int count;
    @Nullable
    private final String memory;
    private final Number memoryInBytes;
    private final long hits;
    private final long misses;
    private final long evictions;
    private final long hitsTimeInMillis;
    private final long missesTimeInMillis;
    public static final JsonpDeserializer<SecurityRolesDlsBitSetCache> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SecurityRolesDlsBitSetCache::setupSecurityRolesDlsBitSetCacheDeserializer);

    private SecurityRolesDlsBitSetCache(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0);
        this.memory = builder.memory;
        this.memoryInBytes = ApiTypeHelper.requireNonNull(builder.memoryInBytes, this, "memoryInBytes");
        this.hits = ApiTypeHelper.requireNonNull(builder.hits, (Object)this, "hits", 0L);
        this.misses = ApiTypeHelper.requireNonNull(builder.misses, (Object)this, "misses", 0L);
        this.evictions = ApiTypeHelper.requireNonNull(builder.evictions, (Object)this, "evictions", 0L);
        this.hitsTimeInMillis = ApiTypeHelper.requireNonNull(builder.hitsTimeInMillis, (Object)this, "hitsTimeInMillis", 0L);
        this.missesTimeInMillis = ApiTypeHelper.requireNonNull(builder.missesTimeInMillis, (Object)this, "missesTimeInMillis", 0L);
    }

    public static SecurityRolesDlsBitSetCache of(Function<Builder, ObjectBuilder<SecurityRolesDlsBitSetCache>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int count() {
        return this.count;
    }

    @Nullable
    public final String memory() {
        return this.memory;
    }

    public final Number memoryInBytes() {
        return this.memoryInBytes;
    }

    public final long hits() {
        return this.hits;
    }

    public final long misses() {
        return this.misses;
    }

    public final long evictions() {
        return this.evictions;
    }

    public final long hitsTimeInMillis() {
        return this.hitsTimeInMillis;
    }

    public final long missesTimeInMillis() {
        return this.missesTimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        if (this.memory != null) {
            generator.writeKey("memory");
            generator.write(this.memory);
        }
        generator.writeKey("memory_in_bytes");
        generator.write(this.memoryInBytes.doubleValue());
        generator.writeKey("hits");
        generator.write(this.hits);
        generator.writeKey("misses");
        generator.write(this.misses);
        generator.writeKey("evictions");
        generator.write(this.evictions);
        generator.writeKey("hits_time_in_millis");
        generator.write(this.hitsTimeInMillis);
        generator.writeKey("misses_time_in_millis");
        generator.write(this.missesTimeInMillis);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSecurityRolesDlsBitSetCacheDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count");
        op.add(Builder::memory, JsonpDeserializer.stringDeserializer(), "memory");
        op.add(Builder::memoryInBytes, JsonpDeserializer.numberDeserializer(), "memory_in_bytes");
        op.add(Builder::hits, JsonpDeserializer.longDeserializer(), "hits");
        op.add(Builder::misses, JsonpDeserializer.longDeserializer(), "misses");
        op.add(Builder::evictions, JsonpDeserializer.longDeserializer(), "evictions");
        op.add(Builder::hitsTimeInMillis, JsonpDeserializer.longDeserializer(), "hits_time_in_millis");
        op.add(Builder::missesTimeInMillis, JsonpDeserializer.longDeserializer(), "misses_time_in_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SecurityRolesDlsBitSetCache> {
        private Integer count;
        @Nullable
        private String memory;
        private Number memoryInBytes;
        private Long hits;
        private Long misses;
        private Long evictions;
        private Long hitsTimeInMillis;
        private Long missesTimeInMillis;

        public final Builder count(int value) {
            this.count = value;
            return this;
        }

        public final Builder memory(@Nullable String value) {
            this.memory = value;
            return this;
        }

        public final Builder memoryInBytes(Number value) {
            this.memoryInBytes = value;
            return this;
        }

        public final Builder hits(long value) {
            this.hits = value;
            return this;
        }

        public final Builder misses(long value) {
            this.misses = value;
            return this;
        }

        public final Builder evictions(long value) {
            this.evictions = value;
            return this;
        }

        public final Builder hitsTimeInMillis(long value) {
            this.hitsTimeInMillis = value;
            return this;
        }

        public final Builder missesTimeInMillis(long value) {
            this.missesTimeInMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SecurityRolesDlsBitSetCache build() {
            this._checkSingleUse();
            return new SecurityRolesDlsBitSetCache(this);
        }
    }
}

