/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.User;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GetUserResponse
implements JsonpSerializable {
    private final Map<String, User> users;
    public static final JsonpDeserializer<GetUserResponse> _DESERIALIZER = GetUserResponse.createGetUserResponseDeserializer();

    private GetUserResponse(Builder builder) {
        this.users = ApiTypeHelper.unmodifiableRequired(builder.users, (Object)this, "users");
    }

    public static GetUserResponse of(Function<Builder, ObjectBuilder<GetUserResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, User> users() {
        return this.users;
    }

    @Nullable
    public final User get(String key) {
        return this.users.get(key);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        for (Map.Entry<String, User> item0 : this.users.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static JsonpDeserializer<GetUserResponse> createGetUserResponseDeserializer() {
        JsonpDeserializer<Map<String, User>> valueDeserializer = JsonpDeserializer.stringMapDeserializer(User._DESERIALIZER);
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().users((Map)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetUserResponse> {
        private Map<String, User> users = new HashMap<String, User>();

        public final Builder users(Map<String, User> map) {
            this.users = Builder._mapPutAll(this.users, map);
            return this;
        }

        public final Builder users(String key, User value) {
            this.users = Builder._mapPut(this.users, key, value);
            return this;
        }

        public final Builder users(String key, Function<User.Builder, ObjectBuilder<User>> fn) {
            return this.users(key, fn.apply(new User.Builder()).build());
        }

        @Override
        public Builder withJson(JsonParser parser, JsonpMapper mapper) {
            Map<String, User> value = JsonpDeserializer.stringMapDeserializer(User._DESERIALIZER).deserialize(parser, mapper);
            return this.users(value);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetUserResponse build() {
            this._checkSingleUse();
            return new GetUserResponse(this);
        }
    }
}

