/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.rest5_client.low_level;

import co.elastic.clients.transport.rest5_client.low_level.BasicAsyncEntityProducer;
import co.elastic.clients.transport.rest5_client.low_level.Cancellable;
import co.elastic.clients.transport.rest5_client.low_level.DeadHostState;
import co.elastic.clients.transport.rest5_client.low_level.HttpDeleteWithEntity;
import co.elastic.clients.transport.rest5_client.low_level.HttpGetWithEntity;
import co.elastic.clients.transport.rest5_client.low_level.Node;
import co.elastic.clients.transport.rest5_client.low_level.NodeSelector;
import co.elastic.clients.transport.rest5_client.low_level.Request;
import co.elastic.clients.transport.rest5_client.low_level.RequestLogger;
import co.elastic.clients.transport.rest5_client.low_level.Response;
import co.elastic.clients.transport.rest5_client.low_level.ResponseException;
import co.elastic.clients.transport.rest5_client.low_level.ResponseListener;
import co.elastic.clients.transport.rest5_client.low_level.Rest5ClientBuilder;
import co.elastic.clients.transport.rest5_client.low_level.WarningFailureException;
import co.elastic.clients.transport.rest5_client.low_level.WarningsHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hc.client5.http.ConnectTimeoutException;
import org.apache.hc.client5.http.async.HttpAsyncClient;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpOptions;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpTrace;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.GzipCompressingEntity;
import org.apache.hc.client5.http.entity.GzipDecompressingEntity;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.ContentTooLongException;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.support.AsyncRequestBuilder;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.reactor.IOReactorStatus;

public class Rest5Client
implements Closeable {
    public static final String IGNORE_RESPONSE_CODES_PARAM = "ignore";
    private static final Log logger = LogFactory.getLog(Rest5Client.class);
    private final CloseableHttpAsyncClient client;
    final List<Header> defaultHeaders;
    private final String pathPrefix;
    private final AtomicInteger lastNodeIndex = new AtomicInteger(0);
    private final ConcurrentMap<HttpHost, DeadHostState> blacklist = new ConcurrentHashMap<HttpHost, DeadHostState>();
    private final FailureListener failureListener;
    private final NodeSelector nodeSelector;
    private volatile List<Node> nodes;
    private final WarningsHandler warningsHandler;
    private final boolean compressionEnabled;
    private final boolean metaHeaderEnabled;

    Rest5Client(CloseableHttpAsyncClient client, Header[] defaultHeaders, List<Node> nodes, String pathPrefix, FailureListener failureListener, NodeSelector nodeSelector, boolean strictDeprecationMode, boolean compressionEnabled, boolean metaHeaderEnabled) {
        this.client = client;
        this.defaultHeaders = Collections.unmodifiableList(Arrays.asList(defaultHeaders));
        this.failureListener = failureListener;
        this.pathPrefix = pathPrefix;
        this.nodeSelector = nodeSelector;
        this.warningsHandler = strictDeprecationMode ? WarningsHandler.STRICT : WarningsHandler.PERMISSIVE;
        this.compressionEnabled = compressionEnabled;
        this.metaHeaderEnabled = metaHeaderEnabled;
        this.setNodes(nodes);
    }

    public static Rest5ClientBuilder builder(URI ... uris) {
        return Rest5Client.builder(Arrays.asList(uris));
    }

    public static Rest5ClientBuilder builder(List<URI> uris) {
        if (uris == null || uris.isEmpty()) {
            throw new IllegalArgumentException("uris must not be null nor empty");
        }
        String prefix = uris.get(0).getPath();
        List<Node> nodes = uris.stream().map(u -> {
            if (!u.isAbsolute()) {
                throw new IllegalArgumentException("Expecting an absolute url: [" + String.valueOf(u) + "]");
            }
            if (!Objects.equals(u.getPath(), prefix)) {
                throw new IllegalArgumentException("All hosts must have the same URL path (" + String.valueOf(uris.get(0)) + " and " + String.valueOf(u) + ")");
            }
            return new Node(HttpHost.create((URI)u));
        }).toList();
        Rest5ClientBuilder result = new Rest5ClientBuilder(nodes);
        if (prefix != null && !prefix.isEmpty()) {
            result.setPathPrefix(prefix);
        }
        return result;
    }

    public static Rest5ClientBuilder builder(Node ... nodes) {
        return new Rest5ClientBuilder(nodes == null ? null : Arrays.asList(nodes));
    }

    public static Rest5ClientBuilder builder(HttpHost ... hosts) {
        if (hosts == null || hosts.length == 0) {
            throw new IllegalArgumentException("hosts must not be null nor empty");
        }
        List<Node> nodes = Arrays.stream(hosts).map(Node::new).collect(Collectors.toList());
        return new Rest5ClientBuilder(nodes);
    }

    public HttpAsyncClient getHttpClient() {
        return this.client;
    }

    public synchronized void setNodes(Collection<Node> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            throw new IllegalArgumentException("node list must not be null or empty");
        }
        LinkedHashMap<HttpHost, Node> nodesByHost = new LinkedHashMap<HttpHost, Node>();
        for (Node node : nodes) {
            Objects.requireNonNull(node, "node cannot be null");
            nodesByHost.put(node.getHost(), node);
        }
        this.nodes = new ArrayList(nodesByHost.values());
        this.blacklist.clear();
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public boolean isRunning() {
        return this.client.getStatus() == IOReactorStatus.ACTIVE;
    }

    public Response performRequest(Request request) throws IOException {
        InternalRequest internalRequest = new InternalRequest(request);
        return this.performRequest(this.nextNodes(), internalRequest, null);
    }

    private Response performRequest(Iterator<Node> nodes, InternalRequest request, Exception previousException) throws IOException {
        ClassicHttpResponse httpResponse;
        RequestContext context = request.createContextForNextAttempt(nodes.next());
        try {
            httpResponse = (ClassicHttpResponse)this.client.execute(context.requestProducer, context.asyncResponseConsumer, (HttpContext)context.context, null).get();
        }
        catch (Exception e) {
            RequestLogger.logFailedRequest(logger, (HttpUriRequest)request.httpRequest, context.node, e);
            this.onFailure(context.node);
            Exception cause = Rest5Client.extractAndWrapCause(e);
            Rest5Client.addSuppressedException(previousException, cause);
            if (Rest5Client.isRetryableException(e) && nodes.hasNext()) {
                return this.performRequest(nodes, request, cause);
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new IllegalStateException("unexpected exception type: must be either RuntimeException or IOException", cause);
        }
        ResponseOrResponseException responseOrResponseException = this.convertResponse(request, context.node, httpResponse);
        if (responseOrResponseException.responseException == null) {
            return responseOrResponseException.response;
        }
        Rest5Client.addSuppressedException(previousException, responseOrResponseException.responseException);
        if (nodes.hasNext()) {
            return this.performRequest(nodes, request, responseOrResponseException.responseException);
        }
        throw responseOrResponseException.responseException;
    }

    private ResponseOrResponseException convertResponse(InternalRequest request, Node node, ClassicHttpResponse httpResponse) throws IOException {
        RequestLogger.logResponse(logger, (HttpUriRequest)request.httpRequest, node.getHost(), httpResponse);
        int statusCode = httpResponse.getCode();
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            Header encoding = null;
            try {
                encoding = httpResponse.getHeader("Content-Encoding");
            }
            catch (ProtocolException e) {
                throw new IOException("Couldn't retrieve content encoding: " + String.valueOf((Object)e));
            }
            if (encoding != null && "gzip".equals(encoding.getValue())) {
                httpResponse.setEntity((HttpEntity)new GzipDecompressingEntity(entity));
                httpResponse.removeHeaders("Content-Encoding");
                httpResponse.removeHeaders("Content-Length");
            }
        }
        Response response = new Response(new RequestLine((HttpRequest)request.httpRequest), node.getHost(), httpResponse);
        if (Rest5Client.isCorrectServerResponse(statusCode)) {
            this.onResponse(node);
            if (request.warningsHandler.warningsShouldFailRequest(response.getWarnings())) {
                throw new WarningFailureException(response);
            }
            return new ResponseOrResponseException(response);
        }
        ResponseException responseException = new ResponseException(response);
        if (Rest5Client.isRetryStatus(statusCode)) {
            this.onFailure(node);
            return new ResponseOrResponseException(responseException);
        }
        this.onResponse(node);
        throw responseException;
    }

    public Cancellable performRequestAsync(Request request, ResponseListener responseListener) {
        try {
            FailureTrackingResponseListener failureTrackingResponseListener = new FailureTrackingResponseListener(responseListener);
            InternalRequest internalRequest = new InternalRequest(request);
            this.performRequestAsync(this.nextNodes(), internalRequest, failureTrackingResponseListener);
            return internalRequest.cancellable;
        }
        catch (Exception e) {
            responseListener.onFailure(e);
            return Cancellable.NO_OP;
        }
    }

    private void performRequestAsync(final Iterator<Node> nodes, final InternalRequest request, final FailureTrackingResponseListener listener) {
        request.cancellable.runIfNotCancelled(() -> {
            final RequestContext context = request.createContextForNextAttempt((Node)nodes.next());
            Future futureRef = this.client.execute(context.requestProducer, context.asyncResponseConsumer, (HttpContext)context.context, (FutureCallback)new FutureCallback<ClassicHttpResponse>(){

                public void completed(ClassicHttpResponse httpResponse) {
                    try {
                        ResponseOrResponseException responseOrResponseException = Rest5Client.this.convertResponse(request, context.node, httpResponse);
                        if (responseOrResponseException.responseException == null) {
                            listener.onSuccess(responseOrResponseException.response);
                        } else if (nodes.hasNext()) {
                            listener.trackFailure(responseOrResponseException.responseException);
                            Rest5Client.this.performRequestAsync(nodes, request, listener);
                        } else {
                            listener.onDefinitiveFailure(responseOrResponseException.responseException);
                        }
                    }
                    catch (Exception e) {
                        listener.onDefinitiveFailure(e);
                    }
                }

                public void failed(Exception failure) {
                    try {
                        RequestLogger.logFailedRequest(logger, (HttpUriRequest)request.httpRequest, context.node, failure);
                        Rest5Client.this.onFailure(context.node);
                        if (Rest5Client.isRetryableException(failure) && nodes.hasNext()) {
                            listener.trackFailure(failure);
                            Rest5Client.this.performRequestAsync(nodes, request, listener);
                        } else {
                            listener.onDefinitiveFailure(failure);
                        }
                    }
                    catch (Exception e) {
                        listener.onDefinitiveFailure(e);
                    }
                }

                public void cancelled() {
                    listener.onDefinitiveFailure(Cancellable.newCancellationException());
                }
            });
            if (futureRef instanceof org.apache.hc.core5.concurrent.Cancellable) {
                request.httpRequest.setDependency((org.apache.hc.core5.concurrent.Cancellable)futureRef);
            }
        });
    }

    private Iterator<Node> nextNodes() throws IOException {
        List<Node> nodes = this.nodes;
        return Rest5Client.selectNodes(nodes, this.blacklist, this.lastNodeIndex, this.nodeSelector).iterator();
    }

    static Iterable<Node> selectNodes(List<Node> nodes, Map<HttpHost, DeadHostState> blacklist, AtomicInteger lastNodeIndex, NodeSelector nodeSelector) throws IOException {
        ArrayList<Node> livingNodes = new ArrayList<Node>(Math.max(0, nodes.size() - blacklist.size()));
        ArrayList<DeadNode> deadNodes = null;
        if (!blacklist.isEmpty()) {
            deadNodes = new ArrayList<DeadNode>(blacklist.size());
            new ArrayList(blacklist.size());
            for (Node node : nodes) {
                DeadHostState deadness = blacklist.get(node.getHost());
                if (deadness == null || deadness.shallBeRetried()) {
                    livingNodes.add(node);
                    continue;
                }
                deadNodes.add(new DeadNode(node, deadness));
            }
        } else {
            livingNodes.addAll(nodes);
        }
        if (!livingNodes.isEmpty()) {
            ArrayList<Node> selectedLivingNodes = new ArrayList<Node>(livingNodes);
            nodeSelector.select(selectedLivingNodes);
            if (!selectedLivingNodes.isEmpty()) {
                Collections.rotate(selectedLivingNodes, lastNodeIndex.getAndIncrement());
                return selectedLivingNodes;
            }
        }
        if (deadNodes != null && !deadNodes.isEmpty()) {
            ArrayList selectedDeadNodes = new ArrayList(deadNodes);
            nodeSelector.select(() -> new DeadNodeIteratorAdapter(selectedDeadNodes.iterator()));
            if (!selectedDeadNodes.isEmpty()) {
                return Collections.singletonList(((DeadNode)Collections.min(selectedDeadNodes)).node);
            }
        }
        throw new IOException("NodeSelector [" + String.valueOf(nodeSelector) + "] rejected all nodes, living: " + String.valueOf(livingNodes) + " and dead: " + String.valueOf(deadNodes));
    }

    private void onResponse(Node node) {
        DeadHostState removedHost = (DeadHostState)this.blacklist.remove(node.getHost());
        if (logger.isDebugEnabled() && removedHost != null) {
            logger.debug((Object)("removed [" + String.valueOf(node) + "] from blacklist"));
        }
    }

    private void onFailure(Node node) {
        DeadHostState previousDeadHostState = this.blacklist.putIfAbsent(node.getHost(), new DeadHostState(DeadHostState.DEFAULT_TIME_SUPPLIER));
        if (previousDeadHostState == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("added [" + String.valueOf(node) + "] to blacklist"));
            }
        } else {
            this.blacklist.replace(node.getHost(), previousDeadHostState, new DeadHostState(previousDeadHostState));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("updated [" + String.valueOf(node) + "] already in blacklist"));
            }
        }
        this.failureListener.onFailure(node);
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    private static boolean isCorrectServerResponse(int statusCode) {
        return statusCode < 500;
    }

    private static boolean isRetryStatus(int statusCode) {
        switch (statusCode) {
            case 502: 
            case 503: 
            case 504: {
                return true;
            }
        }
        return false;
    }

    private static boolean isRetryableException(Throwable e) {
        if (e instanceof ExecutionException) {
            e = e.getCause();
        }
        return !(e instanceof ContentTooLongException);
    }

    private static void addSuppressedException(Exception suppressedException, Exception currentException) {
        if (suppressedException != null && suppressedException != currentException) {
            currentException.addSuppressed(suppressedException);
        }
    }

    private static HttpUriRequestBase createHttpRequest(String method, URI uri, HttpEntity entity, boolean compressionEnabled) {
        switch (method.toUpperCase(Locale.ROOT)) {
            case "DELETE": {
                return Rest5Client.addRequestBody(new HttpDeleteWithEntity(uri), entity, compressionEnabled);
            }
            case "GET": {
                return Rest5Client.addRequestBody(new HttpGetWithEntity(uri), entity, compressionEnabled);
            }
            case "HEAD": {
                return Rest5Client.addRequestBody((HttpUriRequestBase)new HttpHead(uri), entity, compressionEnabled);
            }
            case "OPTIONS": {
                return Rest5Client.addRequestBody((HttpUriRequestBase)new HttpOptions(uri), entity, compressionEnabled);
            }
            case "PATCH": {
                return Rest5Client.addRequestBody((HttpUriRequestBase)new HttpPatch(uri), entity, compressionEnabled);
            }
            case "POST": {
                HttpPost httpPost = new HttpPost(uri);
                Rest5Client.addRequestBody((HttpUriRequestBase)httpPost, entity, compressionEnabled);
                return httpPost;
            }
            case "PUT": {
                return Rest5Client.addRequestBody((HttpUriRequestBase)new HttpPut(uri), entity, compressionEnabled);
            }
            case "TRACE": {
                return Rest5Client.addRequestBody((HttpUriRequestBase)new HttpTrace(uri), entity, compressionEnabled);
            }
        }
        throw new UnsupportedOperationException("http method not supported: " + method);
    }

    private static HttpUriRequestBase addRequestBody(HttpUriRequestBase httpRequest, HttpEntity entity, boolean compressionEnabled) {
        if (entity != null) {
            if (Rest5Client.canHaveBody((HttpRequest)httpRequest)) {
                if (compressionEnabled) {
                    entity = new ContentCompressingEntity((HttpEntity)entity);
                }
                httpRequest.setEntity(entity);
            } else {
                throw new UnsupportedOperationException(httpRequest.getMethod() + " with body is not supported");
            }
        }
        return httpRequest;
    }

    private static boolean canHaveBody(HttpRequest httpRequest) {
        return httpRequest.getMethod().equals("PUT") || httpRequest.getMethod().equals("POST") || httpRequest.getMethod().equals("PATCH") || httpRequest instanceof HttpDeleteWithEntity || httpRequest instanceof HttpGetWithEntity;
    }

    static URI buildUri(String pathPrefix, String path, Map<String, String> params) {
        Objects.requireNonNull(path, "path must not be null");
        try {
            Object fullPath = pathPrefix != null && !pathPrefix.isEmpty() ? (pathPrefix.endsWith("/") && path.startsWith("/") ? pathPrefix.substring(0, pathPrefix.length() - 1) + path : (pathPrefix.endsWith("/") || path.startsWith("/") ? pathPrefix + path : pathPrefix + "/" + path)) : path;
            URIBuilder uriBuilder = new URIBuilder((String)fullPath);
            for (Map.Entry<String, String> param : params.entrySet()) {
                uriBuilder.addParameter(param.getKey(), param.getValue());
            }
            return uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private static Exception extractAndWrapCause(Exception exception) {
        Object e;
        if (exception instanceof InterruptedException) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("thread waiting for the response was interrupted", exception);
        }
        if (exception instanceof ExecutionException) {
            Throwable t;
            ExecutionException executionException = (ExecutionException)exception;
            Throwable throwable = t = executionException.getCause() == null ? executionException : executionException.getCause();
            if (t instanceof Error) {
                throw (Error)t;
            }
            exception = t;
        }
        if (exception instanceof ConnectTimeoutException) {
            e = new ConnectTimeoutException(exception.getMessage());
            e.initCause((Throwable)exception);
            return e;
        }
        if (exception instanceof SocketTimeoutException) {
            e = new SocketTimeoutException(exception.getMessage());
            ((Throwable)e).initCause(exception);
            return e;
        }
        if (exception instanceof ConnectionClosedException) {
            e = new ConnectionClosedException(exception.getMessage(), (Throwable)exception);
            return e;
        }
        if (exception instanceof SSLHandshakeException) {
            e = new SSLHandshakeException(exception.getMessage());
            ((Throwable)e).initCause(exception);
            return e;
        }
        if (exception instanceof ConnectException) {
            e = new ConnectException(exception.getMessage());
            ((Throwable)e).initCause(exception);
            return e;
        }
        if (exception instanceof IOException) {
            return new IOException(exception.getMessage(), exception);
        }
        if (exception instanceof RuntimeException) {
            return new RuntimeException(exception.getMessage(), exception);
        }
        return new RuntimeException("error while performing request", exception);
    }

    public static class FailureListener {
        public void onFailure(Node node) {
        }
    }

    private class InternalRequest {
        private final Request request;
        private final HttpUriRequestBase httpRequest;
        private final Cancellable cancellable;
        private final WarningsHandler warningsHandler;

        InternalRequest(Request request) {
            this.request = request;
            HashMap<String, String> params = new HashMap<String, String>(request.getParameters());
            params.putAll(request.getOptions().getParameters());
            URI uri = Rest5Client.buildUri(Rest5Client.this.pathPrefix, request.getEndpoint(), params);
            this.httpRequest = Rest5Client.createHttpRequest(request.getMethod(), uri, request.getEntity(), Rest5Client.this.compressionEnabled);
            this.cancellable = Cancellable.fromRequest(this.httpRequest);
            this.setHeaders((HttpRequest)this.httpRequest, request.getOptions().getHeaders());
            this.setRequestConfig(this.httpRequest, request.getOptions().getRequestConfig());
            this.warningsHandler = request.getOptions().getWarningsHandler() == null ? Rest5Client.this.warningsHandler : request.getOptions().getWarningsHandler();
        }

        private void setHeaders(HttpRequest req, Collection<Header> requestHeaders) {
            HashSet<String> requestNames = new HashSet<String>(requestHeaders.size());
            for (Header requestHeader : requestHeaders) {
                req.addHeader(requestHeader);
                requestNames.add(requestHeader.getName());
            }
            for (Header defaultHeader : Rest5Client.this.defaultHeaders) {
                if (requestNames.contains(defaultHeader.getName())) continue;
                req.addHeader(defaultHeader);
            }
            if (Rest5Client.this.compressionEnabled) {
                req.addHeader("Accept-Encoding", (Object)"gzip");
            }
            if (Rest5Client.this.metaHeaderEnabled) {
                if (!req.containsHeader("X-Elastic-Client-Meta")) {
                    req.setHeader("X-Elastic-Client-Meta", (Object)Rest5ClientBuilder.META_HEADER_VALUE);
                }
            } else {
                req.removeHeaders("X-Elastic-Client-Meta");
            }
        }

        private void setRequestConfig(HttpUriRequestBase requestBase, RequestConfig requestConfig) {
            if (requestConfig != null) {
                requestBase.setConfig(requestConfig);
            }
        }

        RequestContext createContextForNextAttempt(Node node) {
            this.httpRequest.reset();
            return new RequestContext(this, node);
        }
    }

    private static class RequestContext {
        private final Node node;
        private final AsyncRequestProducer requestProducer;
        private final AsyncResponseConsumer<ClassicHttpResponse> asyncResponseConsumer;
        private final HttpClientContext context;

        RequestContext(InternalRequest request, Node node) {
            this.node = node;
            AsyncRequestBuilder builder = AsyncRequestBuilder.create((String)request.httpRequest.getMethod()).setUri(request.httpRequest.getRequestUri()).setHttpHost(node.getHost()).setHeaders(request.httpRequest.getHeaders());
            if (request.httpRequest.getEntity() != null) {
                builder.setEntity((AsyncEntityProducer)new BasicAsyncEntityProducer(request.httpRequest.getEntity()));
            }
            this.requestProducer = builder.build();
            this.asyncResponseConsumer = request.request.getOptions().getHttpAsyncResponseConsumerFactory().createHttpAsyncResponseConsumer();
            this.context = HttpClientContext.create();
        }
    }

    private static class ResponseOrResponseException {
        private final Response response;
        private final ResponseException responseException;

        ResponseOrResponseException(Response response) {
            this.response = Objects.requireNonNull(response);
            this.responseException = null;
        }

        ResponseOrResponseException(ResponseException responseException) {
            this.responseException = Objects.requireNonNull(responseException);
            this.response = null;
        }
    }

    static class FailureTrackingResponseListener {
        private final ResponseListener responseListener;
        private volatile Exception exception;

        FailureTrackingResponseListener(ResponseListener responseListener) {
            this.responseListener = responseListener;
        }

        void onSuccess(Response response) {
            this.responseListener.onSuccess(response);
        }

        void onDefinitiveFailure(Exception e) {
            this.trackFailure(e);
            this.responseListener.onFailure(this.exception);
        }

        void trackFailure(Exception e) {
            Rest5Client.addSuppressedException(this.exception, e);
            this.exception = e;
        }
    }

    private static class DeadNode
    implements Comparable<DeadNode> {
        final Node node;
        final DeadHostState deadness;

        DeadNode(Node node, DeadHostState deadness) {
            this.node = node;
            this.deadness = deadness;
        }

        public String toString() {
            return this.node.toString();
        }

        @Override
        public int compareTo(DeadNode rhs) {
            return this.deadness.compareTo(rhs.deadness);
        }
    }

    public static class ContentCompressingEntity
    extends GzipCompressingEntity {
        public ContentCompressingEntity(HttpEntity entity) {
            super(entity);
        }

        public InputStream getContent() throws IOException {
            ByteArrayInputOutputStream out = new ByteArrayInputOutputStream(1024);
            this.writeTo(out);
            return out.asInput();
        }
    }

    private static class DeadNodeIteratorAdapter
    implements Iterator<Node> {
        private final Iterator<DeadNode> itr;

        private DeadNodeIteratorAdapter(Iterator<DeadNode> itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public Node next() {
            return this.itr.next().node;
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }

    private static class ByteArrayInputOutputStream
    extends ByteArrayOutputStream {
        ByteArrayInputOutputStream(int size) {
            super(size);
        }

        public InputStream asInput() {
            return new ByteArrayInputStream(this.buf, 0, this.count);
        }
    }
}

