/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.InferenceChunkingSettings;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class InferenceEndpoint
implements JsonpSerializable {
    @Nullable
    private final InferenceChunkingSettings chunkingSettings;
    private final String service;
    private final JsonData serviceSettings;
    @Nullable
    private final JsonData taskSettings;
    public static final JsonpDeserializer<InferenceEndpoint> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InferenceEndpoint::setupInferenceEndpointDeserializer);

    protected InferenceEndpoint(AbstractBuilder<?> builder) {
        this.chunkingSettings = builder.chunkingSettings;
        this.service = ApiTypeHelper.requireNonNull(builder.service, this, "service");
        this.serviceSettings = ApiTypeHelper.requireNonNull(builder.serviceSettings, this, "serviceSettings");
        this.taskSettings = builder.taskSettings;
    }

    public static InferenceEndpoint inferenceEndpointOf(Function<Builder, ObjectBuilder<InferenceEndpoint>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final InferenceChunkingSettings chunkingSettings() {
        return this.chunkingSettings;
    }

    public final String service() {
        return this.service;
    }

    public final JsonData serviceSettings() {
        return this.serviceSettings;
    }

    @Nullable
    public final JsonData taskSettings() {
        return this.taskSettings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.chunkingSettings != null) {
            generator.writeKey("chunking_settings");
            this.chunkingSettings.serialize(generator, mapper);
        }
        generator.writeKey("service");
        generator.write(this.service);
        generator.writeKey("service_settings");
        this.serviceSettings.serialize(generator, mapper);
        if (this.taskSettings != null) {
            generator.writeKey("task_settings");
            this.taskSettings.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupInferenceEndpointDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::chunkingSettings, InferenceChunkingSettings._DESERIALIZER, "chunking_settings");
        op.add(AbstractBuilder::service, JsonpDeserializer.stringDeserializer(), "service");
        op.add(AbstractBuilder::serviceSettings, JsonData._DESERIALIZER, "service_settings");
        op.add(AbstractBuilder::taskSettings, JsonData._DESERIALIZER, "task_settings");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private InferenceChunkingSettings chunkingSettings;
        private String service;
        private JsonData serviceSettings;
        @Nullable
        private JsonData taskSettings;

        public final BuilderT chunkingSettings(@Nullable InferenceChunkingSettings value) {
            this.chunkingSettings = value;
            return (BuilderT)this.self();
        }

        public final BuilderT chunkingSettings(Function<InferenceChunkingSettings.Builder, ObjectBuilder<InferenceChunkingSettings>> fn) {
            return this.chunkingSettings(fn.apply(new InferenceChunkingSettings.Builder()).build());
        }

        public final BuilderT service(String value) {
            this.service = value;
            return (BuilderT)this.self();
        }

        public final BuilderT serviceSettings(JsonData value) {
            this.serviceSettings = value;
            return (BuilderT)this.self();
        }

        public final BuilderT taskSettings(@Nullable JsonData value) {
            this.taskSettings = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<InferenceEndpoint> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public InferenceEndpoint build() {
            this._checkSingleUse();
            return new InferenceEndpoint(this);
        }
    }
}

