/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.UpdateModelSnapshotResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UpdateModelSnapshotRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String description;
    private final String jobId;
    @Nullable
    private final Boolean retain;
    private final String snapshotId;
    public static final JsonpDeserializer<UpdateModelSnapshotRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateModelSnapshotRequest::setupUpdateModelSnapshotRequestDeserializer);
    public static final Endpoint<UpdateModelSnapshotRequest, UpdateModelSnapshotResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateModelSnapshotRequest, UpdateModelSnapshotResponse>("es/ml.update_model_snapshot", request -> "POST", request -> {
        boolean _snapshotId = true;
        int _jobId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/model_snapshots");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.snapshotId, buf);
            buf.append("/_update");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _snapshotId = true;
        int _jobId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("jobId", request.jobId);
            params.put("snapshotId", request.snapshotId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, UpdateModelSnapshotResponse._DESERIALIZER);

    private UpdateModelSnapshotRequest(Builder builder) {
        this.description = builder.description;
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.retain = builder.retain;
        this.snapshotId = ApiTypeHelper.requireNonNull(builder.snapshotId, this, "snapshotId");
    }

    public static UpdateModelSnapshotRequest of(Function<Builder, ObjectBuilder<UpdateModelSnapshotRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    public final String jobId() {
        return this.jobId;
    }

    @Nullable
    public final Boolean retain() {
        return this.retain;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.retain != null) {
            generator.writeKey("retain");
            generator.write(this.retain.booleanValue());
        }
    }

    protected static void setupUpdateModelSnapshotRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::retain, JsonpDeserializer.booleanDeserializer(), "retain");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UpdateModelSnapshotRequest> {
        @Nullable
        private String description;
        private String jobId;
        @Nullable
        private Boolean retain;
        private String snapshotId;

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder retain(@Nullable Boolean value) {
            this.retain = value;
            return this;
        }

        public final Builder snapshotId(String value) {
            this.snapshotId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpdateModelSnapshotRequest build() {
            this._checkSingleUse();
            return new UpdateModelSnapshotRequest(this);
        }
    }
}

