/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Archive
extends Base {
    private final long indicesCount;
    public static final JsonpDeserializer<Archive> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Archive::setupArchiveDeserializer);

    private Archive(Builder builder) {
        super(builder);
        this.indicesCount = ApiTypeHelper.requireNonNull(builder.indicesCount, (Object)this, "indicesCount", 0L);
    }

    public static Archive of(Function<Builder, ObjectBuilder<Archive>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long indicesCount() {
        return this.indicesCount;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("indices_count");
        generator.write(this.indicesCount);
    }

    protected static void setupArchiveDeserializer(ObjectDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::indicesCount, JsonpDeserializer.longDeserializer(), "indices_count");
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<Archive> {
        private Long indicesCount;

        public final Builder indicesCount(long value) {
            this.indicesCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Archive build() {
            this._checkSingleUse();
            return new Archive(this);
        }
    }
}

