/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.elasticsearch.cluster.stats.CCSUsageStats;
import co.elastic.clients.elasticsearch.cluster.stats.RemoteClusterInfo;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CCSStats
implements JsonpSerializable {
    private final Map<String, RemoteClusterInfo> clusters;
    private final CCSUsageStats search;
    @Nullable
    private final CCSUsageStats esql;
    public static final JsonpDeserializer<CCSStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CCSStats::setupCCSStatsDeserializer);

    private CCSStats(Builder builder) {
        this.clusters = ApiTypeHelper.unmodifiable(builder.clusters);
        this.search = ApiTypeHelper.requireNonNull(builder.search, this, "search");
        this.esql = builder.esql;
    }

    public static CCSStats of(Function<Builder, ObjectBuilder<CCSStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, RemoteClusterInfo> clusters() {
        return this.clusters;
    }

    public final CCSUsageStats search() {
        return this.search;
    }

    @Nullable
    public final CCSUsageStats esql() {
        return this.esql;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.clusters)) {
            generator.writeKey("clusters");
            generator.writeStartObject();
            for (Map.Entry<String, RemoteClusterInfo> item0 : this.clusters.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("_search");
        this.search.serialize(generator, mapper);
        if (this.esql != null) {
            generator.writeKey("_esql");
            this.esql.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupCCSStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::clusters, JsonpDeserializer.stringMapDeserializer(RemoteClusterInfo._DESERIALIZER), "clusters");
        op.add(Builder::search, CCSUsageStats._DESERIALIZER, "_search");
        op.add(Builder::esql, CCSUsageStats._DESERIALIZER, "_esql");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CCSStats> {
        @Nullable
        private Map<String, RemoteClusterInfo> clusters;
        private CCSUsageStats search;
        @Nullable
        private CCSUsageStats esql;

        public final Builder clusters(Map<String, RemoteClusterInfo> map) {
            this.clusters = Builder._mapPutAll(this.clusters, map);
            return this;
        }

        public final Builder clusters(String key, RemoteClusterInfo value) {
            this.clusters = Builder._mapPut(this.clusters, key, value);
            return this;
        }

        public final Builder clusters(String key, Function<RemoteClusterInfo.Builder, ObjectBuilder<RemoteClusterInfo>> fn) {
            return this.clusters(key, fn.apply(new RemoteClusterInfo.Builder()).build());
        }

        public final Builder search(CCSUsageStats value) {
            this.search = value;
            return this;
        }

        public final Builder search(Function<CCSUsageStats.Builder, ObjectBuilder<CCSUsageStats>> fn) {
            return this.search(fn.apply(new CCSUsageStats.Builder()).build());
        }

        public final Builder esql(@Nullable CCSUsageStats value) {
            this.esql = value;
            return this;
        }

        public final Builder esql(Function<CCSUsageStats.Builder, ObjectBuilder<CCSUsageStats>> fn) {
            return this.esql(fn.apply(new CCSUsageStats.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CCSStats build() {
            this._checkSingleUse();
            return new CCSStats(this);
        }
    }
}

