/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateBase;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class StatsAggregate
extends AggregateBase
implements AggregateVariant {
    private final long count;
    @Nullable
    private final Double min;
    @Nullable
    private final Double max;
    @Nullable
    private final Double avg;
    private final double sum;
    @Nullable
    private final String minAsString;
    @Nullable
    private final String maxAsString;
    @Nullable
    private final String avgAsString;
    @Nullable
    private final String sumAsString;
    public static final JsonpDeserializer<StatsAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StatsAggregate::setupStatsAggregateDeserializer);

    protected StatsAggregate(AbstractBuilder<?> builder) {
        super(builder);
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0L);
        this.min = builder.min;
        this.max = builder.max;
        this.avg = builder.avg;
        this.sum = ApiTypeHelper.requireNonNull(builder.sum, (Object)this, "sum", 0.0);
        this.minAsString = builder.minAsString;
        this.maxAsString = builder.maxAsString;
        this.avgAsString = builder.avgAsString;
        this.sumAsString = builder.sumAsString;
    }

    public static StatsAggregate statsAggregateOf(Function<Builder, ObjectBuilder<StatsAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.Stats;
    }

    public final long count() {
        return this.count;
    }

    @Nullable
    public final Double min() {
        return this.min;
    }

    @Nullable
    public final Double max() {
        return this.max;
    }

    @Nullable
    public final Double avg() {
        return this.avg;
    }

    public final double sum() {
        return this.sum;
    }

    @Nullable
    public final String minAsString() {
        return this.minAsString;
    }

    @Nullable
    public final String maxAsString() {
        return this.maxAsString;
    }

    @Nullable
    public final String avgAsString() {
        return this.avgAsString;
    }

    @Nullable
    public final String sumAsString() {
        return this.sumAsString;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("count");
        generator.write(this.count);
        if (this.min != null) {
            generator.writeKey("min");
            generator.write(this.min.doubleValue());
        }
        if (this.max != null) {
            generator.writeKey("max");
            generator.write(this.max.doubleValue());
        }
        if (this.avg != null) {
            generator.writeKey("avg");
            generator.write(this.avg.doubleValue());
        }
        generator.writeKey("sum");
        generator.write(this.sum);
        if (this.minAsString != null) {
            generator.writeKey("min_as_string");
            generator.write(this.minAsString);
        }
        if (this.maxAsString != null) {
            generator.writeKey("max_as_string");
            generator.write(this.maxAsString);
        }
        if (this.avgAsString != null) {
            generator.writeKey("avg_as_string");
            generator.write(this.avgAsString);
        }
        if (this.sumAsString != null) {
            generator.writeKey("sum_as_string");
            generator.write(this.sumAsString);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupStatsAggregateDeserializer(ObjectDeserializer<BuilderT> op) {
        AggregateBase.setupAggregateBaseDeserializer(op);
        op.add(AbstractBuilder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(AbstractBuilder::min, JsonpDeserializer.doubleDeserializer(), "min");
        op.add(AbstractBuilder::max, JsonpDeserializer.doubleDeserializer(), "max");
        op.add(AbstractBuilder::avg, JsonpDeserializer.doubleDeserializer(), "avg");
        op.add(AbstractBuilder::sum, JsonpDeserializer.doubleDeserializer(), "sum");
        op.add(AbstractBuilder::minAsString, JsonpDeserializer.stringDeserializer(), "min_as_string");
        op.add(AbstractBuilder::maxAsString, JsonpDeserializer.stringDeserializer(), "max_as_string");
        op.add(AbstractBuilder::avgAsString, JsonpDeserializer.stringDeserializer(), "avg_as_string");
        op.add(AbstractBuilder::sumAsString, JsonpDeserializer.stringDeserializer(), "sum_as_string");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends AggregateBase.AbstractBuilder<BuilderT> {
        private Long count;
        @Nullable
        private Double min;
        @Nullable
        private Double max;
        @Nullable
        private Double avg;
        private Double sum;
        @Nullable
        private String minAsString;
        @Nullable
        private String maxAsString;
        @Nullable
        private String avgAsString;
        @Nullable
        private String sumAsString;

        public final BuilderT count(long value) {
            this.count = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT min(@Nullable Double value) {
            this.min = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT max(@Nullable Double value) {
            this.max = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT avg(@Nullable Double value) {
            this.avg = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT sum(double value) {
            this.sum = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT minAsString(@Nullable String value) {
            this.minAsString = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT maxAsString(@Nullable String value) {
            this.maxAsString = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT avgAsString(@Nullable String value) {
            this.avgAsString = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT sumAsString(@Nullable String value) {
            this.sumAsString = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<StatsAggregate> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StatsAggregate build() {
            this._checkSingleUse();
            return new StatsAggregate(this);
        }
    }
}

