/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class GeoHashLocation
implements JsonpSerializable {
    private final String geohash;
    public static final JsonpDeserializer<GeoHashLocation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoHashLocation::setupGeoHashLocationDeserializer);

    private GeoHashLocation(Builder builder) {
        this.geohash = ApiTypeHelper.requireNonNull(builder.geohash, this, "geohash");
    }

    public static GeoHashLocation of(Function<Builder, ObjectBuilder<GeoHashLocation>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String geohash() {
        return this.geohash;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("geohash");
        generator.write(this.geohash);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGeoHashLocationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::geohash, JsonpDeserializer.stringDeserializer(), "geohash");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GeoHashLocation> {
        private String geohash;

        public final Builder geohash(String value) {
            this.geohash = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoHashLocation build() {
            this._checkSingleUse();
            return new GeoHashLocation(this);
        }
    }
}

