/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class NodeInfoBootstrap
implements JsonpSerializable {
    private final String memoryLock;
    public static final JsonpDeserializer<NodeInfoBootstrap> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoBootstrap::setupNodeInfoBootstrapDeserializer);

    private NodeInfoBootstrap(Builder builder) {
        this.memoryLock = ApiTypeHelper.requireNonNull(builder.memoryLock, this, "memoryLock");
    }

    public static NodeInfoBootstrap of(Function<Builder, ObjectBuilder<NodeInfoBootstrap>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String memoryLock() {
        return this.memoryLock;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("memory_lock");
        generator.write(this.memoryLock);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupNodeInfoBootstrapDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::memoryLock, JsonpDeserializer.stringDeserializer(), "memory_lock");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NodeInfoBootstrap> {
        private String memoryLock;

        public final Builder memoryLock(String value) {
            this.memoryLock = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodeInfoBootstrap build() {
            this._checkSingleUse();
            return new NodeInfoBootstrap(this);
        }
    }
}

