/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.license;

import co.elastic.clients.elasticsearch._types.AcknowledgedResponse;
import co.elastic.clients.elasticsearch.license.LicenseType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PostStartBasicResponse
implements AcknowledgedResponse,
JsonpSerializable {
    private final boolean acknowledged;
    private final boolean basicWasStarted;
    @Nullable
    private final String errorMessage;
    @Nullable
    private final LicenseType type;
    private final Map<String, List<String>> acknowledge;
    public static final JsonpDeserializer<PostStartBasicResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PostStartBasicResponse::setupPostStartBasicResponseDeserializer);

    private PostStartBasicResponse(Builder builder) {
        this.acknowledged = ApiTypeHelper.requireNonNull(builder.acknowledged, (Object)this, "acknowledged", false);
        this.basicWasStarted = ApiTypeHelper.requireNonNull(builder.basicWasStarted, (Object)this, "basicWasStarted", false);
        this.errorMessage = builder.errorMessage;
        this.type = builder.type;
        this.acknowledge = ApiTypeHelper.unmodifiable(builder.acknowledge);
    }

    public static PostStartBasicResponse of(Function<Builder, ObjectBuilder<PostStartBasicResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public final boolean acknowledged() {
        return this.acknowledged;
    }

    public final boolean basicWasStarted() {
        return this.basicWasStarted;
    }

    @Nullable
    public final String errorMessage() {
        return this.errorMessage;
    }

    @Nullable
    public final LicenseType type() {
        return this.type;
    }

    public final Map<String, List<String>> acknowledge() {
        return this.acknowledge;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("acknowledged");
        generator.write(this.acknowledged);
        generator.writeKey("basic_was_started");
        generator.write(this.basicWasStarted);
        if (this.errorMessage != null) {
            generator.writeKey("error_message");
            generator.write(this.errorMessage);
        }
        if (this.type != null) {
            generator.writeKey("type");
            this.type.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.acknowledge)) {
            generator.writeKey("acknowledge");
            generator.writeStartObject();
            for (Map.Entry<String, List<String>> item0 : this.acknowledge.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.writeStartArray();
                if (item0.getValue() != null) {
                    for (String item1 : item0.getValue()) {
                        generator.write(item1);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupPostStartBasicResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::acknowledged, JsonpDeserializer.booleanDeserializer(), "acknowledged");
        op.add(Builder::basicWasStarted, JsonpDeserializer.booleanDeserializer(), "basic_was_started");
        op.add(Builder::errorMessage, JsonpDeserializer.stringDeserializer(), "error_message");
        op.add(Builder::type, LicenseType._DESERIALIZER, "type");
        op.add(Builder::acknowledge, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())), "acknowledge");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<PostStartBasicResponse> {
        private Boolean acknowledged;
        private Boolean basicWasStarted;
        @Nullable
        private String errorMessage;
        @Nullable
        private LicenseType type;
        @Nullable
        private Map<String, List<String>> acknowledge;

        public final Builder acknowledged(boolean value) {
            this.acknowledged = value;
            return this;
        }

        public final Builder basicWasStarted(boolean value) {
            this.basicWasStarted = value;
            return this;
        }

        public final Builder errorMessage(@Nullable String value) {
            this.errorMessage = value;
            return this;
        }

        public final Builder type(@Nullable LicenseType value) {
            this.type = value;
            return this;
        }

        public final Builder acknowledge(Map<String, List<String>> map) {
            this.acknowledge = Builder._mapPutAll(this.acknowledge, map);
            return this;
        }

        public final Builder acknowledge(String key, List<String> value) {
            this.acknowledge = Builder._mapPut(this.acknowledge, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PostStartBasicResponse build() {
            this._checkSingleUse();
            return new PostStartBasicResponse(this);
        }
    }
}

