/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateVariant;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeBucket;
import co.elastic.clients.elasticsearch._types.aggregations.MultiBucketAggregateBase;
import co.elastic.clients.elasticsearch.security.query_api_keys.ApiKeyAggregate;
import co.elastic.clients.elasticsearch.security.query_api_keys.ApiKeyAggregateVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CompositeAggregate
extends MultiBucketAggregateBase<CompositeBucket>
implements AggregateVariant,
ApiKeyAggregateVariant {
    private final Map<String, FieldValue> afterKey;
    public static final JsonpDeserializer<CompositeAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CompositeAggregate::setupCompositeAggregateDeserializer);

    private CompositeAggregate(Builder builder) {
        super(builder);
        this.afterKey = ApiTypeHelper.unmodifiable(builder.afterKey);
    }

    public static CompositeAggregate of(Function<Builder, ObjectBuilder<CompositeAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.Composite;
    }

    @Override
    public ApiKeyAggregate.Kind _apiKeyAggregateKind() {
        return ApiKeyAggregate.Kind.Composite;
    }

    public final Map<String, FieldValue> afterKey() {
        return this.afterKey;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.afterKey)) {
            generator.writeKey("after_key");
            generator.writeStartObject();
            for (Map.Entry<String, FieldValue> item0 : this.afterKey.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupCompositeAggregateDeserializer(ObjectDeserializer<Builder> op) {
        MultiBucketAggregateBase.setupMultiBucketAggregateBaseDeserializer(op, CompositeBucket._DESERIALIZER);
        op.add(Builder::afterKey, JsonpDeserializer.stringMapDeserializer(FieldValue._DESERIALIZER), "after_key");
    }

    public static class Builder
    extends MultiBucketAggregateBase.AbstractBuilder<CompositeBucket, Builder>
    implements ObjectBuilder<CompositeAggregate> {
        @Nullable
        private Map<String, FieldValue> afterKey;

        public final Builder afterKey(Map<String, FieldValue> map) {
            this.afterKey = Builder._mapPutAll(this.afterKey, map);
            return this;
        }

        public final Builder afterKey(String key, FieldValue value) {
            this.afterKey = Builder._mapPut(this.afterKey, key, value);
            return this;
        }

        public final Builder afterKey(String key, String value) {
            this.afterKey = Builder._mapPut(this.afterKey, key, FieldValue.of(value));
            return this;
        }

        public final Builder afterKey(String key, long value) {
            this.afterKey = Builder._mapPut(this.afterKey, key, FieldValue.of(value));
            return this;
        }

        public final Builder afterKey(String key, double value) {
            this.afterKey = Builder._mapPut(this.afterKey, key, FieldValue.of(value));
            return this;
        }

        public final Builder afterKey(String key, boolean value) {
            this.afterKey = Builder._mapPut(this.afterKey, key, FieldValue.of(value));
            return this;
        }

        public final Builder afterKey(String key, Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.afterKey(key, fn.apply(new FieldValue.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CompositeAggregate build() {
            this._checkSingleUse();
            super.tBucketSerializer(null);
            return new CompositeAggregate(this);
        }
    }
}

